/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.cookie;

import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.client.utils.DateUtils;
import com.aliyun.log.thirdparty.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.aliyun.log.thirdparty.org.apache.http.cookie.MalformedCookieException;
import com.aliyun.log.thirdparty.org.apache.http.cookie.SetCookie;
import com.aliyun.log.thirdparty.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value2, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

