/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.log.thirdparty.org.apache.http.impl.cookie;

import com.aliyun.log.thirdparty.org.apache.http.annotation.Immutable;
import com.aliyun.log.thirdparty.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.aliyun.log.thirdparty.org.apache.http.cookie.MalformedCookieException;
import com.aliyun.log.thirdparty.org.apache.http.cookie.SetCookie;
import com.aliyun.log.thirdparty.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.aliyun.log.thirdparty.org.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value2);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value2);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

