package com.alibaba.schedulerx.worker.actor;

import java.util.List;

import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogCharsRequest;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogCharsResponse;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogRequest;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogResponse;
import com.alibaba.schedulerx.protocol.Server.ServerTailLogRequest;
import com.alibaba.schedulerx.protocol.Server.ServerTailLogResponse;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import akka.actor.UntypedActor;
import com.google.common.collect.Lists;

/**
 *
 * @author xiaomeng.hxm
 */
@Deprecated
public class LogActor extends UntypedActor {
    private static final Logger LOGGER = LogFactory.getLogger(LogActor.class);

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof ServerTailLogRequest) {
            handleTailLog((ServerTailLogRequest) obj);
        } else if (obj instanceof ServerReadLogRequest) {
            handleReadLog((ServerReadLogRequest) obj);
        } else if (obj instanceof ServerReadLogCharsRequest) {
            handleReadLogChars((ServerReadLogCharsRequest) obj);
        }

    }

    private void handleTailLog(ServerTailLogRequest request) {
        ServerTailLogResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            List<String> lines = collector.tailLines(request.getNum(), StreamType.STD_ERR);
            List<String> lines = Lists.newArrayList("not support");
            response = ServerTailLogResponse.newBuilder().setSuccess(true).addAllLine(lines).build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerTailLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }

    private void handleReadLog(ServerReadLogRequest request) {
        ServerReadLogResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            List<String> lines = collector.readLines(request.getOffset(), request.getSize(), StreamType.STD_ERR);
            List<String> lines = Lists.newArrayList("not support");
            response = ServerReadLogResponse.newBuilder()
                    .setSuccess(true)
                    .addAllLine(lines)
                    .setOffset(request.getOffset() + lines.size())
                    .setIsEnd(lines.isEmpty())
                    .build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerReadLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }

    private void handleReadLogChars(ServerReadLogCharsRequest request) {
        ServerReadLogCharsResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            LogReadResult logResult = collector.readChars(request.getOffset(), request.getSize(), StreamType.STD_ERR);
            LogReadResult logResult = new LogReadResult(true, "not support", 0);
            response = ServerReadLogCharsResponse.newBuilder()
                    .setSuccess(true)
                    .setLog(logResult.getLog())
                    .setOffset(logResult.getOffset())
                    .setIsEnd(logResult.isEnd())
                    .build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerReadLogCharsResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }
}
