package com.alibaba.schedulerx.worker.container;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

/**
 *
 * @author xiaomeng.hxm
 */
public class ContainerFactory {
    private static final Logger LOGGER = LogFactory.getLogger(ContainerFactory.class);
    private static String containType;
    private static ContainerPool containerPool;

    public static Container create(JobContext context) throws Exception {
        Container container = null;
        if (containType == null) {
            containType = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_CONTAINER_TYPE, "thread");
        }
        if (containType != null) {
            //todo:这里应该按照context的值来而不是通过配置文件过来?
            if (containType.equals("thread")) {
                container = new ThreadContainer(context, getContainerPool());
            } else if (containType.equals("actor")) {
                container = new ActorContainer(context);
            } else if (containType.equals("process")) {
                container = new ProcessContainer(context);
            } else if (containType.equals("docker")) {
                container = new DockerContainer(context);
            }
        }
        return container;
    }

    public static ContainerPool getContainerPool() {
        if (containerPool == null) {
            if (containType == null) {
                containType = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_CONTAINER_TYPE, "thread");
            }
            if (containType.equals("thread")) {
                containerPool = ThreadContainerPool.getInstance();
            } else {
                //TODO
            }
        }
        return containerPool;
    }
}
