package com.alibaba.schedulerx.worker.discovery;

import java.util.Map;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import com.google.common.collect.Maps;

/**
 * Created by yanxun on 2018/5/23.
 *
 * @author yanxun
 * @date 2018/05/23
 */
public class ServerDiscoveryFactory {
//    private static ServerDiscovery serverDiscovery;
    private static Map<String, ServerDiscovery> SERVER_DiSCOVERY_MAP = Maps.newConcurrentMap();
    private static final Logger LOGGER = LogFactory.getLogger(ServerDiscoveryFactory.class);

//    static {
//        try {
//            String serverCacheImpl = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_SERVER_DISCOVERY,
//                DefaultServerDiscovery.class.getName());
//            serverDiscovery = ReflectionUtil.getInstanceByClassName(serverCacheImpl);
//        } catch (ClassNotFoundException e) {
//            LOGGER.error("init server cache implementation error!", e);
//            serverDiscovery = null;
//        }
//    }
//
//    @Deprecated
//    public static ServerDiscovery getDiscovery() {
//        return serverDiscovery;
//    }

//    public static ServerDiscovery create() throws Exception {
//        String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_SERVER_DISCOVERY,
//                DefaultServerDiscovery.class.getName());
//        ServerDiscovery serverDiscovery = ReflectionUtil.getInstanceByClassName(className);
//        return serverDiscovery;
//    }

    public static ServerDiscovery getDiscovery(String groupId) {
        if (!SERVER_DiSCOVERY_MAP.containsKey(groupId)) {
            synchronized (SERVER_DiSCOVERY_MAP) {
                if (!SERVER_DiSCOVERY_MAP.containsKey(groupId)) {
                    String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_SERVER_DISCOVERY,
                            DefaultServerDiscovery.class.getName());
                    try {
                        ServerDiscovery serverDiscovery = ReflectionUtil.getInstanceByClassName(className,
                                SchedulerxWorker.CUSTOMER_CLASS_LOADER);
                        SERVER_DiSCOVERY_MAP.put(groupId, serverDiscovery);
                    } catch (Throwable e) {
                        LOGGER.error("", e);
                    }
                }
            }
        }
        return SERVER_DiSCOVERY_MAP.get(groupId);
    }
    
    public static void clear() throws Exception {
        for (ServerDiscovery discovery : SERVER_DiSCOVERY_MAP.values()) {
            discovery.stop();
        }
        SERVER_DiSCOVERY_MAP.clear();
    }
}
