package com.alibaba.schedulerx.worker.domain;

import java.util.List;
import java.util.Map;

import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;

import org.joda.time.DateTime;

/**
 *
 * @author xiaomeng.hxm
 */
public final class JobContext {
    //基本信息
    private long jobId;
    private long jobInstanceId;
    private Long wfInstanceId;
    private long taskId = 0;
    private String jobName;
    private DateTime scheduleTime;
    private DateTime dataTime;
    private String executeMode;
    private String jobType;
    private String instanceMasterActorPath;
    private String taskName;
    private Object task;
    private String groupId;
    private String content;
    private String user;

    //jobInstance最大重试次数
    private int maxAttempt;
    //jobInstance当前重试次数
    private int attempt;

    // 任务自定义参数
    private String jobParameters;

    // 每次触发传递自定义参数，仅api触发可以传递
    private String instanceParameters;
    
    //工作流上游数据
    private List<JobInstanceData> upstreamData;

    //所有子任务的结果Map<taskId, result>
    private Map<Long, String> taskResults;
    
    //所有子任务的状态 Map<taskId, taskStatus>
    private Map<Long, TaskStatus> taskStatuses;

    //task最大重试次数
    private int taskMaxAttempt;
    //task当前重试次数
    private int taskAttempt = 0;
    //task重试间隔(秒)
    private int taskAttemptInterval;

    //秒级任务循环次数
    private long serialNum;

    private LogCollector logCollector;
    
    //分片id
    private Long shardingId;
    //分片参数
    private String shardingParameter;
    //分片个数
    private int shardingNum = 0;
    
    private List<String> allWorkerAddrs;
    private String workerAddr;
    
    private int timeType;
    private String timeExpression;
    
    private JobContext() {}

    public long getJobId() {
        return jobId;
    }

    public long getJobInstanceId() {
        return jobInstanceId;
    }

    public Long getWfInstanceId() {
        return wfInstanceId;
    }

    public long getTaskId() {
        return taskId;
    }

    public String getUniqueId() {
        return IdUtil.getUniqueId(jobId, jobInstanceId, taskId);
    }

    public String getJobName() {
        return jobName;
    }

    public DateTime getScheduleTime() {
        return scheduleTime;
    }

    public DateTime getDataTime() {
        return dataTime;
    }

    public String getExecuteMode() {
        return executeMode;
    }

    public String getJobType() {
        return jobType;
    }

    public String getContent() {
        return content;
    }

    public String getUser() {
        return user;
    }

    public String getJobParameters() {
        return jobParameters;
    }

    public String getInstanceParameters() {
        return instanceParameters;
    }
    
    public String getTaskMasterActorPath() {
        return getInstanceMasterActorPath();
    }

    public String getInstanceMasterActorPath() {
        return instanceMasterActorPath;
    }

    public String getTaskName() {
        return taskName;
    }

    public Object getTask() {
        return task;
    }

    public int getTaskMaxAttempt() {
        return taskMaxAttempt;
    }

    public int getTaskAttemptInterval() {
        return taskAttemptInterval;
    }

    private void collectLog(String log) {
        logCollector.collect(getUniqueId(), log);
    }

    public String getGroupId() {
        return groupId;
    }

    public List<JobInstanceData> getUpstreamData() {
        return upstreamData;
    }

    public Map<Long, String> getTaskResults() {
        return taskResults;
    }
    
    public Map<Long, TaskStatus> getTaskStatuses() {
        return taskStatuses;
    }

    public int getMaxAttempt() {
        return maxAttempt;
    }

    public int getAttempt() {
        return attempt;
    }

    public long getSerialNum() {
        return serialNum;
    }

    public int getTaskAttempt() {
        return taskAttempt;
    }
    
    public Long getShardingId() {
        return shardingId;
    }
    
    public String getShardingParameter() {
        return shardingParameter;
    }

    public void setTaskAttempt(int taskAttempt) {
        this.taskAttempt = taskAttempt;
    }

    public void setInstanceParameters(String instanceParameters) {
        this.instanceParameters = instanceParameters;
    }

    public int getShardingNum() {
        return shardingNum;
    }

    public List<String> getAllWorkerAddrs() {
        return allWorkerAddrs;
    }

    public String getWorkerAddr() {
        return workerAddr;
    }
    
    public int getTimeType() {
        return timeType;
    }
    
    public String getTimeExpression() {
        return timeExpression;
    }

    public static JobContextBuilder newBuilder() {
        return new JobContextBuilder();
    }

    public static JobContextBuilder newBuilder(JobContext context) {
        return new JobContextBuilder(context);
    }

    public static final class JobContextBuilder {
        private JobContext context = new JobContext();

        private JobContextBuilder() {}

        private JobContextBuilder(JobContext context) {
            this.context = context;
        }

        public JobContextBuilder setJobId(long jobId) {
            this.context.jobId = jobId;
            return this;
        }

        public JobContextBuilder setJobInstanceId(long jobInstanceId) {
            this.context.jobInstanceId = jobInstanceId;
            return this;
        }

        public JobContextBuilder setWfInstanceId(long wfInstanceId) {
            this.context.wfInstanceId = wfInstanceId;
            return this;
        }

        public JobContextBuilder setTaskId(long taskId) {
            this.context.taskId = taskId;
            return this;
        }

        public JobContextBuilder setJobName(String jobName) {
            this.context.jobName = jobName;
            return this;
        }

        public JobContextBuilder setScheduleTime(DateTime scheduleTime) {
            this.context.scheduleTime = scheduleTime;
            return this;
        }

        public JobContextBuilder setDataTime(DateTime dataTime) {
            this.context.dataTime = dataTime;
            return this;
        }

        public JobContextBuilder setExecuteMode(String executeMode) {
            this.context.executeMode = executeMode;
            return this;
        }

        public JobContextBuilder setJobType(String jobType) {
            this.context.jobType = jobType;
            return this;
        }

        public JobContextBuilder setContent(String content) {
            this.context.content = content;
            return this;
        }

        public JobContextBuilder setUser(String user) {
            this.context.user = user;
            return this;
        }

        public JobContextBuilder setJobParameters(String jobParameters) {
            this.context.jobParameters = jobParameters;
            return this;
        }

        public JobContextBuilder setInstanceParameters(String instanceParameters) {
            this.context.instanceParameters = instanceParameters;
            return this;
        }
        
        public JobContextBuilder setTaskMasterActorPath(String actorPath) {
            this.context.instanceMasterActorPath = actorPath;
            return this;
        }

        public JobContextBuilder setTaskName(String taskName) {
            this.context.taskName = taskName;
            return this;
        }

        public JobContextBuilder setTask(Object task) {
            this.context.task = task;
            return this;
        }

        public JobContextBuilder setGroupId(String groupId) {
            this.context.groupId = groupId;
            return this;
        }

        public JobContextBuilder setUpstreamData(List<JobInstanceData> upstreamData) {
            this.context.upstreamData = upstreamData;
            return this;
        }

        public JobContextBuilder setTaskResults(Map<Long, String> taskResults) {
            this.context.taskResults = taskResults;
            return this;
        }
        
        public JobContextBuilder setTaskStatuses(Map<Long, TaskStatus> taskStatuses) {
            this.context.taskStatuses = taskStatuses;
            return this;
        }

        public JobContextBuilder setMaxAttempt(int maxAttempt) {
            this.context.maxAttempt = maxAttempt;
            return this;
        }

        public JobContextBuilder setAttempt(int attempt) {
            this.context.attempt = attempt;
            return this;
        }

        public JobContextBuilder setTaskMaxAttempt(int taskMaxAttempt) {
            this.context.taskMaxAttempt = taskMaxAttempt;
            return this;
        }

        public JobContextBuilder setTaskAttemptInterval(int taskAttemptInterval) {
            this.context.taskAttemptInterval = taskAttemptInterval;
            return this;
        }

        public JobContextBuilder setSerialNum(long serialNum) {
            this.context.serialNum = serialNum;
            return this;
        }
        
        public JobContextBuilder setShardingId(long shardingId) {
            this.context.shardingId = shardingId;
            return this;
        }
        
        public JobContextBuilder setShardingParameter(String shardingParameter) {
            this.context.shardingParameter = shardingParameter;
            return this;
        }
        
        public JobContextBuilder setShardingNum(int shardingNum) {
            this.context.shardingNum = shardingNum;
            return this;
        }
        
        public JobContextBuilder setAllWorkerAddrs(List<String> allWorkerAddrs) {
            this.context.allWorkerAddrs = allWorkerAddrs;
            return this;
        }
        
        public JobContextBuilder setWorkerAddrs(String workerAddr) {
            this.context.workerAddr = workerAddr;
            return this;
        }
        
        public JobContextBuilder setTimeType(int timeType) {
            this.context.timeType = timeType;
            return this;
        }
        
        public JobContextBuilder setTimeExpression(String timeExpression) {
            this.context.timeExpression = timeExpression;
            return this;
        }

        public JobContext build() {
            if (ConfigUtil.getWorkerConfig().getBoolean(WorkerConstants.LOG_COLLECTOR_ENABLE, WorkerConstants.LOG_COLLECTOR_ENABLE_DEFAULT)) {
                this.context.logCollector = LogCollectorFactory.get();
            }
            return context;
        }

    }

}
