package com.alibaba.schedulerx.worker.ha;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActor;

/**
 *
 * @author xiaomeng.hxm
 */
public class AtLeastOnceDeliveryRoutingActor extends UntypedActor {
    private int size;
    private List<ActorRef> actors = new ArrayList<ActorRef>();
    private static final Logger LOGGER = LogFactory.getLogger(AtLeastOnceDeliveryRoutingActor.class);

    public AtLeastOnceDeliveryRoutingActor(int size) {
        this.size = size;
        for (int i = 0; i < size; i++) {
            ActorRef containerActor = getContext().actorOf(Props.create(AtLeastOnceDeliveryActor.class, i));
            actors.add(containerActor);
        }
    }

    public static Props props(int size) {
        return Props.create(AtLeastOnceDeliveryRoutingActor.class, size);
    }

    @Override
    public void onReceive(Object obj) throws Exception {
        long jobInstanceId = 0;
        try {
            jobInstanceId = (long) ReflectionUtil.invokeMethod(obj, "getJobInstanceId");
            actors.get((int) (jobInstanceId % size)).forward(obj, getContext());
        } catch (Throwable e){
            LOGGER.warn(obj + "can not be deliverd, jobInstanceId={}", jobInstanceId, e);
        }
    }

}
