package com.alibaba.schedulerx.worker.ha;

/**
 * Schedulerx健康检测相关时间Holder
 * @author zhaibian
 * @version $Id: HealthTimeHolder.java, v 0.1 2019年03月13日 21:07 zhaibian Exp $
 */
public class HealthTimeHolder {
    public static final HealthTimeHolder INSTANCE = new HealthTimeHolder();

    /**
     * 与服务端最后一次心跳检测成功时间
     */
    private long latestServerHeartbeatTime;

    private HealthTimeHolder(){
        latestServerHeartbeatTime = System.currentTimeMillis();
    }

    /**
     * 重置与服务端最后一次心跳检测成功时间
     */
    public void resetServerHeartbeatTime(){
        latestServerHeartbeatTime = System.currentTimeMillis();
    }

    /**gitgit
     * 与服务端最后一次心跳检测成功时间到现在是否大于给定间隔时间
     *
     * @param seconds 超时时间，单位秒
     * @return true为大于超时时间seconds，false没有超时
     */
    public boolean isServerHeartbeatHealthTimeout(int seconds) {
        return System.currentTimeMillis() - latestServerHeartbeatTime > seconds * 1000L;
    }

    /**
     * 与服务端最后一次心跳检测成功时间到现在的间隔时间
     *
     * @return 间隔时间，单位毫秒
     */
    public long getServerHeartbeatMsInterval(){
        return System.currentTimeMillis() - latestServerHeartbeatTime;
    }
}