package com.alibaba.schedulerx.worker.log.appender;

import java.util.List;

import com.aliyun.openservices.aliyun.log.producer.Callback;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.log.common.LogItem;
import org.apache.logging.log4j.Logger;

/**
 * @author xiaomeng.hxm
 *
 */
public class SchedulerxLog4j2AppenderCallback implements Callback {

    private Logger logger;

    private String project;

    private String logStore;

    private String topic;

    private String source;

    private List<LogItem> logItems;

    public SchedulerxLog4j2AppenderCallback(Logger logger, String project, String logStore, String topic,
                                  String source, List<LogItem> logItems) {
        super();
        this.logger = logger;
        this.project = project;
        this.logStore = logStore;
        this.topic = topic;
        this.source = source;
        this.logItems = logItems;
    }

    @Override
    public void onCompletion(Result result) {
        if (!result.isSuccessful()) {
            logger.error(
                    "Failed to send log, project=" + project
                            + ", logStore=" + logStore
                            + ", topic=" + topic
                            + ", source=" + source
                            + ", logItem=" + logItems
                            + ", errorCode=" + result.getErrorCode()
                            + ", errorMessage=" + result.getErrorMessage());
        }
    }
}
