package com.alibaba.schedulerx.worker.log.factory;

import java.net.URL;

import com.alibaba.schedulerx.common.MyClassLoader;
import com.alibaba.schedulerx.worker.log.logger.Log4j2Logger;
import com.alibaba.schedulerx.worker.log.Logger;

import org.apache.logging.log4j.LogManager;

/**
 * @author zhaibian
 * @date 2019/04/23
 */
public class Log4j2LoggerFactory implements SchedulerxLoggerFactory{
    private static org.apache.logging.log4j.spi.LoggerContext SCHEDULERX_LOG_CONTEXT;

    public Log4j2LoggerFactory() throws Exception {
        Class.forName("org.apache.logging.log4j.core.Logger");

        URL url = Log4j2LoggerFactory.class.getResource("/log4j2-schedulerx.xml");
        SCHEDULERX_LOG_CONTEXT = LogManager.getContext(new MyClassLoader(new URL[] {}, Thread
            .currentThread().getContextClassLoader()), false, null, url.toURI());
    }

    @Override
    public Logger getLogger(String name) {
        return new Log4j2Logger(SCHEDULERX_LOG_CONTEXT.getLogger(name));
    }
}
