package com.alibaba.schedulerx.worker.log.factory;

import java.net.URL;

import com.alibaba.schedulerx.worker.log.logger.Log4jLogger;
import com.alibaba.schedulerx.worker.log.Logger;

import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * @author zhaibian
 * @date 2019/04/23
 */
public class Log4jLoggerFactory implements SchedulerxLoggerFactory {

    private static LoggerRepository repository;

    public Log4jLoggerFactory() throws Exception{
        Class.forName("org.apache.log4j.Level");

        repository = new Hierarchy(new RootLogger(Level.DEBUG));
        URL url = Log4j2LoggerFactory.class.getResource("/log4j-schedulerx.xml");
        new DOMConfigurator().doConfigure(url, repository);
    }

    @Override
    public Logger getLogger(String name) {
        return new Log4jLogger(repository.getLogger(name));
    }
}
