package com.alibaba.schedulerx.worker.log.factory;

import java.net.URL;

import com.alibaba.schedulerx.worker.log.logger.LogbackLogger;
import com.alibaba.schedulerx.worker.log.Logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;

/**
 * @author zhaibian
 * @date 2019/04/23
 */
public class LogbackLoggerFactory implements SchedulerxLoggerFactory {
    private static LoggerContext loggerContext ;

    public LogbackLoggerFactory() throws Exception {
        loggerContext = new LoggerContext();
        loggerContext.setName("logback-schedulerx2");
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(loggerContext);
        URL url = Log4j2LoggerFactory.class.getResource("/logback-schedulerx.xml");
        configurator.doConfigure(url);
    }

    @Override
    public Logger getLogger(String name) {
        return new LogbackLogger(loggerContext.getLogger(name));
    }
}
