package com.alibaba.schedulerx.worker.logcollector;

import java.io.IOException;
import java.util.List;

import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.domain.StreamType;

/**
 *
 * @author xiaomeng.hxm
 */
public abstract class LogCollector {

    public static char END_OF_LOG = '\004';   //LOG结束符

    public void collectStdout(String line) {
        collect(line, StreamType.STD_OUT, false);
    }

    public void collectStderr(String line) {
        collect(line, StreamType.STD_ERR, false);
    }

    public void collectStdout(String line, boolean isEnd) {
        collect(line, StreamType.STD_OUT, isEnd);
    }

    public void collectStderr(String line, boolean isEnd) {
        collect(line, StreamType.STD_ERR, isEnd);
    }

    public void collect(String key, String line) {
        collect(key, line, StreamType.STD_OUT, false);
    }

    public void collect(String key, String line, Throwable t) {
        collect(key, line, t, StreamType.STD_ERR, false);
    }

    public void collect(String line, StreamType streamType, boolean isEnd) {
        collect(null, line, streamType, isEnd);
    }

    public void collect(String key, String line, StreamType streamType, boolean isEnd) {
        collect(key, line, null, streamType, isEnd);
    }

    public abstract void collect(String key, String line, Throwable t, StreamType streamType, boolean isEnd);

    public List<String> readLines(long lineOffset, int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public LogReadResult readChars(long offset, int size, StreamType streamType) throws IOException {
        return null;
    }

    public List<String> tailLines(int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public void delete() throws IOException {}

}
