package com.alibaba.schedulerx.worker.master;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 *
 * @author xiaomeng.hxm
 */
public enum TaskMasterPool {
    INSTANCE;

    private Map<Long, TaskMaster> masterPool = Maps.newConcurrentMap();

    public TaskMaster get(long jobInstanceId) {
        return masterPool.get(jobInstanceId);
    }

    public void put(long jobInstanceId, TaskMaster taskMaster) {
        masterPool.put(jobInstanceId, taskMaster);
    }

    public void remove(long jobInstanceId) {
        masterPool.remove(jobInstanceId);
    }

    public boolean contains(long jobInstanceId) {
        return masterPool.containsKey(jobInstanceId);
    }

    public List<Long> getInstanceIds(long appGroupId) {
        List<Long> list = Lists.newArrayList();
        for(TaskMaster taskMaster : getAllTaskMaster()){
            if(taskMaster.getJobInstanceInfo().getAppGroupId() == appGroupId){
                list.add(taskMaster.getJobInstanceInfo().getJobInstanceId());
            }
        }
        return list;
    }

    public void clear() {
        masterPool.clear();
    }

    public Collection<TaskMaster> getAllTaskMaster(){
        return masterPool.values();
    }
}
