package com.alibaba.schedulerx.worker.master.persistence;

import java.util.List;
import java.util.Map;

import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.protocol.Worker.ContainerReportTaskStatusRequest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @author yanxun on 2019/1/12.
 */
public class PersistenceUtil {
    /**
     * get task status classfied by status, workerIdAddr
     * @param taskStatusInfos
     * @return {status -> {workerIdAddr -> list of taskIds}}
     */
    public static Map<Integer, Map<String, List<Long>>> getTaskStatusMap(List<ContainerReportTaskStatusRequest> taskStatusInfos) {
        Map<Integer, Map<String, List<Long>>> status2WorkIdAddr2TaskIds = Maps.newHashMap();
        Map<Long, Integer> statusMap = Maps.newHashMap();
        for (ContainerReportTaskStatusRequest e : taskStatusInfos) {
            Integer status = e.getStatus();
            Long taskId = e.getTaskId();
            String workerIdAddr = e.getWorkerId() + "@" + e.getWorkerAddr();
            addTaskStatusInfo(status2WorkIdAddr2TaskIds, status, workerIdAddr, taskId);
        }
        return status2WorkIdAddr2TaskIds;
    }
    
    public static void addTaskStatusInfo(Map<Integer, Map<String, List<Long>>> status2WorkIdAddr2TaskIds,
                                          Integer status, String workerIdAddr, Long taskId) {
        if (!status2WorkIdAddr2TaskIds.containsKey(status)) {
            // status not exists , all below must be first time add in too
            Map<String, List<Long>> workerAddr2TaskIds = Maps.newHashMap();
            workerAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskId));
            status2WorkIdAddr2TaskIds.put(status, workerAddr2TaskIds);
        } else {
            // status already exists
            Map<String, List<Long>> workerIdAddr2TaskIds = status2WorkIdAddr2TaskIds.get(status);
            if (!workerIdAddr2TaskIds.containsKey(workerIdAddr)) {
                workerIdAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskId));
            } else {
                workerIdAddr2TaskIds.get(workerIdAddr).add(taskId);
            }
        }
    }
}
