package com.alibaba.schedulerx.worker.processor;

import java.io.File;
import java.io.IOException;

import com.alibaba.schedulerx.worker.domain.JobContext;

import com.google.common.io.Files;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class GoProcessor extends ShellProcessor {

    public static final String GO_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/go/";
    private String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(GO_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        fileName = writeGoScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters;
        if (StringUtils.isNotEmpty(context.getShardingParameter())) {
            parameters = new String[2];
            parameters[0] = String.valueOf(context.getShardingId());
            parameters[1] = context.getShardingParameter();
        } else if (StringUtils.isNotEmpty(context.getInstanceParameters())) {
            parameters = context.getInstanceParameters().trim().split(" ");
        } else {
            parameters = context.getJobParameters().trim().split(" ");
        }
        
        String[] contents = new String[3 + parameters.length];
        contents[0] = "go";
        contents[1] = "run";
        contents[2] = fileName;
        for (int i = 0; i < parameters.length; i++) {
            contents[3+i] = parameters[i];
        }
        return contents;
    }

    private String writeGoScript(JobContext context) throws IOException {
        //TODO 加入version
        long jobId = context.getJobId();
        String fileName = GO_SCRIPT_PREFIX + "go_" + jobId + ".go";
        Files.write(context.getContent().getBytes(), new File(fileName));
        return fileName;
    }

}
