package com.alibaba.schedulerx.worker.processor;

import java.util.concurrent.ConcurrentMap;

import com.google.common.collect.Maps;

/**
 * job processor repository
 * 
 * @author xiaomeng.hxm
 *
 */
public class JobProcessorRepository {
    private static ConcurrentMap<String, JobProcessor> jobProcessorRepository = Maps.newConcurrentMap();
    
    public static JobProcessor registJobProcessor(String name, JobProcessor processor){
        return jobProcessorRepository.put(name, processor);
    }
    
    public static JobProcessor loadJobProcessor(String name){
        return jobProcessorRepository.get(name);
    }
}
