package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.common.constants.CommonConstants;
import com.alibaba.schedulerx.common.domain.InstanceStatus;

/**
 *
 * @author xiaomeng.hxm
 */
public class ProcessResult {
    private InstanceStatus status;
    private String result;

    public ProcessResult(InstanceStatus status) {
        this.status = status;
    }

    public ProcessResult(boolean status) {
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
    }

    public ProcessResult(InstanceStatus status, String result) {
        this.status = status;
        this.result = result;
    }

    /**
     *
     * @param status
     * @param result, the size should less than 1000 bytes
     * @throws Exception
     */
    public ProcessResult(boolean status, String result) {
        if (result != null && result.getBytes().length > CommonConstants.INSTANCE_RESULT_SIZE_MAX) {
            throw new RuntimeException("result size more than 1000 bytes!");
        }
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
        this.result = result;
    }

    public InstanceStatus getStatus() {
        return status;
    }

    public void setStatus(InstanceStatus status) {
        this.status = status;
    }

    public void setStatus(boolean status) {
        this.status = (status ? InstanceStatus.SUCCESS : InstanceStatus.FAILED);
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        if (result != null && result.getBytes().length > CommonConstants.INSTANCE_RESULT_SIZE_MAX) {
            throw new RuntimeException("result size more than 1000 bytes!");
        }
        this.result = result;
    }

    @Override
    public String toString() {
        return "ProcessResult [status=" + status + ", result=" + result + "]";
    }
    
}
