package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.common.domain.JobType;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.SpringContext;


/**
 *
 * @author xiaomeng.hxm
 */
public class ProcessorFactory {
    private static final Logger LOGGER = LogFactory.getLogger(ProcessorFactory.class);

    public static JobProcessor create(String type) {
        JobProcessor jobProcessor = null;
        String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_EXECUTOR_PREFIX + type);
        if (className != null) {
            try {
                if (SpringContext.context != null && JobType.JAVA.getKey().equals(type)) {
                    jobProcessor = SpringContext.getBean(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
                } else {
                    jobProcessor = ReflectionUtil.getInstanceByClassName(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
                }
            } catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
        return jobProcessor;
    }
}
