package com.alibaba.schedulerx.worker.processor;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;

import com.alibaba.schedulerx.common.domain.StreamType;




/**
 *
 * @author xiaomeng.hxm
 */
public class ShellStreamProcessor extends Thread {
    private ShellProcessor executor;
    private InputStream inputStream;
    private StreamType type;
    private CountDownLatch countDownLatch;

    public ShellStreamProcessor(ShellProcessor executor, InputStream inputStream, StreamType type, CountDownLatch countDownLatch) {
        this.executor = executor;
        this.inputStream = inputStream;
        this.type = type;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        if (type == StreamType.STD_OUT) {
            executor.processStdOutputStream(inputStream);
        } else if (type == StreamType.STD_ERR) {
            executor.processStdErrorStream(inputStream);
        }

        countDownLatch.countDown();
    }
}
