package com.alibaba.schedulerx.worker.processor.demo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.MapReduceJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;


public class TestMapReduceJobProcessor extends MapReduceJobProcessor {
    private static final Logger LOGGER = LogFactory.getLogger("data");
    
    static class OrderInfo {
        private String id;
        private int value;
        
        public OrderInfo(String id, int value) {
            this.id = id;
            this.value = value;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getValue() {
            return value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "OrderInfo [id=" + id + ", value=" + value + "]";
        }
        
    }
    
     
    @Override
    public ProcessResult process(JobContext context) throws Exception {
        String taskName = context.getTaskName();
        int num = Integer.valueOf(context.getJobParameters());
        
        if (isRootTask(context)) {
            LOGGER.info("start root task");
            List<OrderInfo> orderInfos = new ArrayList<>();
            for (int i = 1; i <= num; i++) {
                orderInfos.add(new OrderInfo("id_" + i, i));
            }
            return map(orderInfos, "OrderInfo");
        } else if (taskName.equals("OrderInfo")) {
            OrderInfo orderInfo = (OrderInfo)context.getTask();
            LOGGER.info("orderInfo=" + orderInfo);
            return new ProcessResult(true, String.valueOf(orderInfo.getValue()));
        }
        return new ProcessResult(false);
    }
    
    @Override
    public ProcessResult reduce(JobContext context) throws Exception {
        Map<Long, String> allTaskResults = context.getTaskResults();
        Map<Long, TaskStatus> allTaskStatuses = context.getTaskStatuses();
        int count = 0;
        for (Entry<Long, String> entry : allTaskResults.entrySet()) {
            // 过滤根任务
            if (entry.getKey() == 0) {
                continue;
            }
            if (allTaskStatuses.get(entry.getKey()).equals(TaskStatus.SUCCESS)) {
                count += Integer.valueOf(entry.getValue());
            }
        }
        LOGGER.info("reduce: count=" + count);
        return new ProcessResult(true, String.valueOf(count));
    }
}
