package com.alibaba.schedulerx.worker.pull;

import java.util.List;
import java.util.concurrent.TimeoutException;

import com.alibaba.schedulerx.protocol.Worker.MasterStartContainerRequest;
import com.alibaba.schedulerx.protocol.Worker.PullTaskFromMasterRequest;
import com.alibaba.schedulerx.protocol.Worker.PullTaskFromMasterResponse;
import com.alibaba.schedulerx.protocol.utils.FutureUtils;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import akka.actor.ActorSelection;
import akka.actor.Address;

/**
 *
 * @author xiaomeng.hxm
 */
public class PullThread extends Thread {

    private final long jobInstanceId;
    private final int pageSize;
    private final BlockingContainerQueue queue;
    private final ActorSelection masterActorSelection;
    private volatile boolean running = true;
    private final String workerIdAddr;
    private static final Logger LOGGER = LogFactory.getLogger(PullThread.class);

    public PullThread(long jobInstanceId, int pageSize, String taskMasterAkkaPath, BlockingContainerQueue queue) {
        super("Schedulerx-PullThread-" + jobInstanceId);
        this.jobInstanceId = jobInstanceId;
        this.pageSize = pageSize;
        this.queue = queue;
        this.masterActorSelection = SchedulerxWorker.actorSystem.actorSelection(taskMasterAkkaPath);
        Address address = SchedulerxWorker.actorSystem.provider().getDefaultAddress();
        this.workerIdAddr = address.system() + "@" + address.host().get() + ":" + address.port().get();
    }

    @Override
    public void run() {
        while (running) {
            PullTaskFromMasterRequest request = PullTaskFromMasterRequest.newBuilder()
                    .setJobInstanceId(jobInstanceId)
                    .setPageSize(pageSize)
                    .setWorkerIdAddr(workerIdAddr)
                    .build();
            try {
                PullTaskFromMasterResponse response = (PullTaskFromMasterResponse) FutureUtils.awaitResult(
                        masterActorSelection, request, 30);
                if (response.getSuccess()) {
                    List<MasterStartContainerRequest> containerRequests = response.getRequestList();
                    if (containerRequests != null && !containerRequests.isEmpty()) {
                        for (MasterStartContainerRequest containerRequest : containerRequests) {
                            boolean insertSuccess = false;
                            while (running && !insertSuccess) {
                                insertSuccess = queue.put(containerRequest);
                            }
                        }
                    } else {
                        Thread.sleep(3000);
                    }
                } else {
                    LOGGER.error("pull container error, " + response.getMessage());
                    PullManager.INSTANCE.stop(jobInstanceId);
                }
            } catch (TimeoutException e) {
                // 如果拉子任务超时，100%会卡住
                LOGGER.error("pull task timeout, stop PullManager");
                PullManager.INSTANCE.crash(jobInstanceId);
            } catch (Throwable e) {
                LOGGER.error("", e);
            }
        }
    }

    public void stopRunning() {
        running = false;
    }
}
