package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.worker.domain.TaskStatistics;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2MemoryPersistence;

/**
 * 检查h2中jobinstance实例数量
 *
 * @author 陆昆
 * @create 2019-01-15 上午10:58
 **/
public class JobInstanceCheckTimer extends AbstractTimerTask {

    @Override
    public String getName() {
        return "JobInstanceCheckTimer";
    }

    @Override
    public long getInitialDelay() {
        // 60s
        return 60;
    }

    @Override
    public long getPeriod() {
        // 60s
        return 60;
    }

    @Override
    public void run() {
        try {
            // mem类型
            if (H2MemoryPersistence.getInstance().isInited()) {
                TaskStatistics memTaskStatistics = H2MemoryPersistence.getInstance().getTaskStatistics();
                if (memTaskStatistics != null) {
                    LOGGER.info("h2 mem distinct instance count: {}, total task count: {}",
                        memTaskStatistics.getDistinctInstanceCount(), memTaskStatistics.getTaskCount());
                }
            }
            // file类型
            if (H2FilePersistence.getInstance().isInited()) {
                TaskStatistics fileTaskStatistics = H2FilePersistence.getInstance().getTaskStatistics();
                if (fileTaskStatistics != null) {
                    LOGGER.info("h2 file distinct instance count: {}, total task count: {}",
                        fileTaskStatistics.getDistinctInstanceCount(), fileTaskStatistics.getTaskCount());
                }
            }
        } catch (Throwable e) {
            LOGGER.error("JobInstanceCheckTimer run error.", e);
        }
    }
}
