package com.alibaba.schedulerx.worker.timer;

import java.util.List;

import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2MemoryPersistence;
import com.alibaba.schedulerx.worker.master.persistence.H2Persistence;

import org.apache.commons.collections.CollectionUtils;

/**
 * 实例清理(补漏)
 *
 * @author 陆昆
 * @create 2019-01-15 下午8:04
 **/
public class JobInstanceCleanTimer extends AbstractTimerTask {
    private TaskMasterPool masterPool = TaskMasterPool.INSTANCE;

    @Override
    public String getName() {
        return "JobInstanceCleanTimer";
    }

    @Override
    public long getInitialDelay() {
        return 60;
    }

    @Override
    public long getPeriod() {
        // 2分钟
        return 2 * 60;
    }

    @Override
    public void run() {
        try {
            if (H2MemoryPersistence.getInstance().isInited()) {
                handleToCleanInstances(H2MemoryPersistence.getInstance());
            }
            if (H2FilePersistence.getInstance().isInited()) {
                handleToCleanInstances(H2MemoryPersistence.getInstance());
            }
        } catch (Throwable e) {
            LOGGER.warn("JobInstanceCleanTimer run error",e);
        }
    }

    private void handleToCleanInstances(H2Persistence h2Persistence) throws Exception{
        List<Long> instanceIds = h2Persistence.getDistinctInstanceIds();
        if (CollectionUtils.isNotEmpty(instanceIds)) {
            for (Long instanceId : instanceIds) {
                if (!masterPool.contains(instanceId)) {
                    h2Persistence.clearTasks(instanceId);
                    LOGGER.info("clear tasks instanceId: {}",instanceId);
                }
            }
        }
    }
}
