/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairbloom;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairbloom.factory.BloomBuilderFactory;
import com.aliyun.tair.tairbloom.params.BfinsertParams;
import com.aliyun.tair.tairbloom.params.BfmaddParams;
import com.aliyun.tair.tairbloom.params.BfmexistParams;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairBloom {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairBloom(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairBloom(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    public String bfreserve(String key, long initCapacity, double errorRate) {
        return this.bfreserve(SafeEncoder.encode((String)key), initCapacity, errorRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bfreserve(byte[] key, long initCapacity, double errorRate) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFRESERVE, (byte[][])new byte[][]{key, Protocol.toByteArray((double)errorRate), Protocol.toByteArray((long)initCapacity)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Boolean bfadd(String key, String item) {
        return this.bfadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean bfadd(byte[] key, byte[] item) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFADD, (byte[][])new byte[][]{key, item});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfmadd(String key, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfmaddParams params = new BfmaddParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFMADD, params.getByteParams(key, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfmadd(byte[] key, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfmaddParams params = new BfmaddParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFMADD, params.getByteParams(key, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean bfexists(String key, String item) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFEXISTS, new String[]{key, item});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean bfexists(byte[] key, byte[] item) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFEXISTS, (byte[][])new byte[][]{key, item});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfmexists(String key, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfmexistParams params = new BfmexistParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFMEXISTS, params.getByteParams(key, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfmexists(byte[] key, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfmexistParams params = new BfmexistParams();
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFMEXISTS, params.getByteParams(key, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfinsert(String key, BfinsertParams params, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])items)));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean[] bfinsert(byte[] key, BfinsertParams params, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(key, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(String key, String initCapacityTag, long initCapacity, String errorRateTag, Double errorRate, String itemTag, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, initCapacityTag, String.valueOf(initCapacity), errorRateTag, String.valueOf(errorRate), itemTag);
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(String key, String nocreateTag, String itemTag, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, nocreateTag, itemTag);
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(String key, String itemTag, String ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, itemTag);
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] initCapacityTag, long initCapacity, byte[] errorRateTag, Double errorRate, byte[] itemTag, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, initCapacityTag, Protocol.toByteArray((long)initCapacity), errorRateTag, Protocol.toByteArray((double)errorRate), itemTag);
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] nocreateTag, byte[] itemTag, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, nocreateTag, itemTag);
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] itemTag, byte[] ... items) {
        Jedis jedis = this.getJedis();
        try {
            BfinsertParams params = new BfinsertParams();
            byte[][] metadata = params.getByteParamsMeta(key, new byte[][]{itemTag});
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
            Boolean[] booleanArray = (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
            return booleanArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> bfdebug(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFDEBUG, new String[]{key});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> bfdebug(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.BFDEBUG, (byte[][])new byte[][]{key});
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

