/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairbloom;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairbloom.factory.BloomBuilderFactory;
import com.aliyun.tair.tairbloom.params.BfinsertParams;
import com.aliyun.tair.tairbloom.params.BfmaddParams;
import com.aliyun.tair.tairbloom.params.BfmexistParams;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairBloomCluster {
    private JedisCluster jc;

    public TairBloomCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public String bfreserve(String key, long initCapacity, double errorRate) {
        return this.bfreserve(SafeEncoder.encode((String)key), initCapacity, errorRate);
    }

    public String bfreserve(byte[] key, long initCapacity, double errorRate) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFRESERVE, (byte[][])new byte[][]{key, Protocol.toByteArray((double)errorRate), Protocol.toByteArray((long)initCapacity)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public Boolean bfadd(String key, String item) {
        return this.bfadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)item));
    }

    public Boolean bfadd(byte[] key, byte[] item) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFADD, (byte[][])new byte[][]{key, item});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean[] bfmadd(String key, String ... items) {
        BfmaddParams params = new BfmaddParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFMADD, params.getByteParams(key, items));
        return (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
    }

    public Boolean[] bfmadd(byte[] key, byte[] ... items) {
        BfmaddParams params = new BfmaddParams();
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFMADD, params.getByteParams(key, items));
        return (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
    }

    public Boolean bfexists(String key, String value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFEXISTS, new String[]{key, value});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean bfexists(byte[] key, byte[] value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFEXISTS, (byte[][])new byte[][]{key, value});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean[] bfmexists(String key, String ... value) {
        BfmexistParams params = new BfmexistParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFMEXISTS, params.getByteParams(key, value));
        return (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
    }

    public Boolean[] bfmexists(byte[] key, byte[] ... value) {
        BfmexistParams params = new BfmexistParams();
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFMEXISTS, params.getByteParams(key, value));
        return (Boolean[])BloomBuilderFactory.BFMADD_RESULT_BOOLEAN_LIST.build(obj);
    }

    public Boolean[] bfinsert(String key, BfinsertParams params, String ... items) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])items)));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    public Boolean[] bfinsert(byte[] key, BfinsertParams params, byte[] ... items) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(key, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(String key, String initCapacityTag, long initCapacity, String errorRateTag, Double errorRate, String itemTag, String ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, initCapacityTag, String.valueOf(initCapacity), errorRateTag, String.valueOf(errorRate), itemTag);
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(String key, String nocreateTag, String itemTag, String ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, nocreateTag, itemTag);
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(String key, String itemTag, String ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, itemTag);
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] initCapacityTag, long initCapacity, byte[] errorRateTag, Double errorRate, byte[] itemTag, byte[] ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, initCapacityTag, Protocol.toByteArray((long)initCapacity), errorRateTag, Protocol.toByteArray((double)errorRate), itemTag);
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] nocreateTag, byte[] itemTag, byte[] ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, nocreateTag, itemTag);
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    @Deprecated
    public Boolean[] bfinsert(byte[] key, byte[] itemTag, byte[] ... items) {
        BfinsertParams params = new BfinsertParams();
        byte[][] metadata = params.getByteParamsMeta(key, new byte[][]{itemTag});
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFINSERT, params.getByteParams(metadata, items));
        return (Boolean[])BloomBuilderFactory.BFINSERT_RESULT_BOOLEAN_LIST.build(obj);
    }

    public List<String> bfdebug(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFDEBUG, new String[]{key});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<String> bfdebug(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.BFDEBUG, (byte[][])new byte[][]{key});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }
}

