/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.taircpc.params;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Params;
import com.aliyun.tair.taircpc.params.CpcArrayData;
import com.aliyun.tair.taircpc.params.CpcArrayMultiData;
import java.util.ArrayList;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class CpcMultiArrayUpdateParams
extends Params {
    public static CpcMultiArrayUpdateParams cpcMultiArrayUpdateParams() {
        return new CpcMultiArrayUpdateParams();
    }

    public byte[][] getByteParams(ArrayList<CpcArrayData> keys) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (CpcArrayData key : keys) {
            byteParams.add(SafeEncoder.encode((String)key.getKey()));
            byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
            byteParams.add(SafeEncoder.encode((String)key.getItem()));
            byteParams.add(SafeEncoder.encode((String)key.getExpStr()));
            byteParams.add(Protocol.toByteArray((long)key.getExp()));
            byteParams.add(SafeEncoder.encode((String)key.getSizeStr()));
            byteParams.add(Protocol.toByteArray((long)key.getSize()));
            byteParams.add(SafeEncoder.encode((String)key.getWinSizeStr()));
            byteParams.add(Protocol.toByteArray((long)key.getWinSize()));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    public byte[][] getByteMultiParams(ArrayList<CpcArrayMultiData> keys) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(SafeEncoder.encode((String)keys.get(0).getKey()));
        for (CpcArrayMultiData key : keys) {
            this.checkMultiData(key);
            switch (key.getType()) {
                case CPCARRAYUPDATE: {
                    this.checkCpcMultiData(key);
                    byteParams.add(ModuleCommand.CPCARRAYUPDATE.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(SafeEncoder.encode((String)((String)key.getValues().get("value"))));
                    break;
                }
                case SUMARRAYADD: {
                    this.checkCpcMultiData(key);
                    byteParams.add(ModuleCommand.SUMARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case MAXARRAYADD: {
                    this.checkCpcMultiData(key);
                    byteParams.add(ModuleCommand.MAXARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case MINARRAYADD: {
                    this.checkCpcMultiData(key);
                    byteParams.add(ModuleCommand.MINARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case FIRSTARRAYADD: {
                    this.checkFirstMultiData(key);
                    byteParams.add(ModuleCommand.FIRSTARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(SafeEncoder.encode((String)((String)key.getValues().get("content"))));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case LASTARRAYADD: {
                    this.checkFirstMultiData(key);
                    byteParams.add(ModuleCommand.LASTARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(SafeEncoder.encode((String)((String)key.getValues().get("content"))));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case AVGARRAYADD: {
                    this.checkAvgMultiData(key);
                    byteParams.add(ModuleCommand.AVGARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(Protocol.toByteArray((long)((Long)key.getValues().get("weight"))));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                case STDDEVARRAYADD: {
                    this.checkCpcMultiData(key);
                    byteParams.add(ModuleCommand.STDDEVARRAYADD.getRaw());
                    byteParams.add(SafeEncoder.encode((String)key.getKey()));
                    byteParams.add(Protocol.toByteArray((long)key.getTimestamp()));
                    byteParams.add(Protocol.toByteArray((double)((Double)key.getValues().get("value"))));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ERR:The option argument error");
                }
            }
            byteParams.add(SafeEncoder.encode((String)key.getExpStr()));
            byteParams.add(Protocol.toByteArray((long)key.getExp()));
            byteParams.add(SafeEncoder.encode((String)key.getSizeStr()));
            byteParams.add(Protocol.toByteArray((long)key.getSize()));
            byteParams.add(SafeEncoder.encode((String)key.getWinSizeStr()));
            byteParams.add(Protocol.toByteArray((long)key.getWinSize()));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    private boolean checkMultiData(CpcArrayMultiData data) {
        if (null == data.getKey()) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return true;
    }

    private boolean checkCpcMultiData(CpcArrayMultiData data) {
        if (null == data.getValues() || null == data.getValues().get("value")) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return true;
    }

    private boolean checkFirstMultiData(CpcArrayMultiData data) {
        if (null == data.getValues() || null == data.getValues().get("value") || null == data.getValues().get("content")) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return true;
    }

    private boolean checkAvgMultiData(CpcArrayMultiData data) {
        if (null == data.getValues() || null == data.getValues().get("value") || null == data.getValues().get("weight")) {
            throw new IllegalArgumentException("ERR:The value is null");
        }
        return true;
    }
}

