/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairdoc;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairdoc.params.JsongetParams;
import com.aliyun.tair.tairdoc.params.JsonsetParams;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairDoc {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairDoc(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairDoc(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonset(String key, String path, String json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSET, new String[]{key, path, json});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonset(String key, String path, String json, JsonsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)path), SafeEncoder.encode((String)json)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonset(byte[] key, byte[] path, byte[] json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSET, (byte[][])new byte[][]{key, path, json});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonset(byte[] key, byte[] path, byte[] json, JsonsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSET, params.getByteParams(key, path, json));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonget(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, new String[]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonget(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, new String[]{key, path});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonget(String key, String path, JsongetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)path)));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsonget(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, (byte[][])new byte[][]{key});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsonget(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, (byte[][])new byte[][]{key, path});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsonget(byte[] key, byte[] path, JsongetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONGET, params.getByteParams(key, path));
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> jsonmget(String ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONMGET, args);
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> jsonmget(byte[] ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONMGET, args);
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsondel(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONDEL, new String[]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsondel(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONDEL, new String[]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsondel(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONDEL, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsondel(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONDEL, (byte[][])new byte[][]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsontype(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONTYPE, new String[]{key});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsontype(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONTYPE, new String[]{key, path});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsontype(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONTYPE, (byte[][])new byte[][]{key});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsontype(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONTYPE, (byte[][])new byte[][]{key, path});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double jsonnumincrBy(String key, Double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double jsonnumincrBy(String key, String path, Double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path), Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double jsonnumincrBy(byte[] key, Double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double jsonnumincrBy(byte[] key, byte[] path, Double value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{key, path, Protocol.toByteArray((double)value)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrAppend(String key, String json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRAPPEND, new String[]{key, json});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrAppend(String key, String path, String json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRAPPEND, new String[]{key, path, json});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrAppend(byte[] key, byte[] json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRAPPEND, (byte[][])new byte[][]{key, json});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrAppend(byte[] key, byte[] path, byte[] json) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRAPPEND, (byte[][])new byte[][]{key, path, json});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrlen(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRLEN, new String[]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrlen(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRLEN, new String[]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrlen(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRLEN, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonstrlen(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONSTRLEN, (byte[][])new byte[][]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrAppend(String ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRAPPEND, args);
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrAppend(byte[] ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRAPPEND, args);
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonarrPop(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRPOP, new String[]{key, path});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String jsonarrPop(String key, String path, int index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRPOP, new String[]{key, path, String.valueOf(index)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsonarrPop(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRPOP, (byte[][])new byte[][]{key, path});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] jsonarrPop(byte[] key, byte[] path, int index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRPOP, (byte[][])new byte[][]{key, path, Protocol.toByteArray((int)index)});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrInsert(String ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRINSERT, args);
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrInsert(byte[] ... args) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRINSERT, args);
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonArrLen(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRLEN, new String[]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonArrLen(String key, String path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRLEN, new String[]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonArrLen(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRLEN, (byte[][])new byte[][]{key});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonArrLen(byte[] key, byte[] path) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRLEN, (byte[][])new byte[][]{key, path});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrTrim(String key, String path, int start, int stop) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRTRIM, new String[]{key, path, String.valueOf(start), String.valueOf(stop)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long jsonarrTrim(byte[] key, byte[] path, int start, int stop) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.JSONARRTRIM, (byte[][])new byte[][]{key, path, Protocol.toByteArray((int)start), Protocol.toByteArray((int)stop)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

