/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairdoc;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairdoc.params.JsongetParams;
import com.aliyun.tair.tairdoc.params.JsonsetParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairDocCluster {
    private JedisCluster jc;

    public TairDocCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public String jsonset(String key, String path, String json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSET, new String[]{key, path, json});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonset(String key, String path, String json, JsonsetParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.JSONSET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)path), SafeEncoder.encode((String)json)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonset(byte[] key, byte[] path, byte[] json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSET, (byte[][])new byte[][]{key, path, json});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonset(byte[] key, byte[] path, byte[] json, JsonsetParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSET, params.getByteParams(key, path, json));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonget(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONGET, new String[]{key});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonget(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONGET, new String[]{key, path});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonget(String key, String path, JsongetParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.JSONGET, params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)path)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] jsonget(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONGET, (byte[][])new byte[][]{key});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public byte[] jsonget(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONGET, (byte[][])new byte[][]{key, path});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public byte[] jsonget(byte[] key, byte[] path, JsongetParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONGET, params.getByteParams(key, path));
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public List<String> jsonmget(String sampleKey, String ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONMGET, args);
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> jsonmget(byte[] sampleKey, byte[] ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONMGET, args);
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public Long jsondel(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONDEL, new String[]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsondel(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONDEL, new String[]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsondel(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONDEL, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsondel(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONDEL, (byte[][])new byte[][]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String jsontype(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONTYPE, new String[]{key});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsontype(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONTYPE, new String[]{key, path});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] jsontype(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONTYPE, (byte[][])new byte[][]{key});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public byte[] jsontype(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONTYPE, (byte[][])new byte[][]{key, path});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Double jsonnumincrBy(String key, Double value) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)key), Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double jsonnumincrBy(String key, String path, Double value) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)key), SafeEncoder.encode((String)path), Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double jsonnumincrBy(byte[] key, Double value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{key, Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double jsonnumincrBy(byte[] key, byte[] path, Double value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONNUMINCRBY, (byte[][])new byte[][]{key, path, Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Long jsonstrAppend(String key, String json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRAPPEND, new String[]{key, json});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrAppend(String key, String path, String json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRAPPEND, new String[]{key, path, json});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrAppend(byte[] key, byte[] json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRAPPEND, (byte[][])new byte[][]{key, json});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrAppend(byte[] key, byte[] path, byte[] json) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRAPPEND, (byte[][])new byte[][]{key, path, json});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrlen(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRLEN, new String[]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrlen(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRLEN, new String[]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrlen(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRLEN, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonstrlen(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONSTRLEN, (byte[][])new byte[][]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonarrAppend(String sampleKey, String ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONARRAPPEND, JoinParameters.joinParameters(sampleKey, args));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonarrAppend(byte[] sampleKey, byte[] ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONARRAPPEND, JoinParameters.joinParameters(sampleKey, args));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String jsonarrPop(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRPOP, new String[]{key, path});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String jsonarrPop(String key, String path, int index) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRPOP, new String[]{key, path, String.valueOf(index)});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] jsonarrPop(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRPOP, (byte[][])new byte[][]{key, path});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public byte[] jsonarrPop(byte[] key, byte[] path, int index) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRPOP, (byte[][])new byte[][]{key, path, Protocol.toByteArray((int)index)});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Long jsonarrInsert(String sampleKey, String ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONARRINSERT, JoinParameters.joinParameters(sampleKey, args));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonarrInsert(byte[] sampleKey, byte[] ... args) {
        Object obj = this.jc.sendCommand(sampleKey, (ProtocolCommand)ModuleCommand.JSONARRINSERT, JoinParameters.joinParameters(sampleKey, args));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonArrLen(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRLEN, new String[]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonArrlen(String key, String path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRLEN, new String[]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonArrLen(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRLEN, (byte[][])new byte[][]{key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonArrLen(byte[] key, byte[] path) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRLEN, (byte[][])new byte[][]{key, path});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonarrTrim(String key, String path, int start, int stop) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRTRIM, new String[]{key, path, String.valueOf(start), String.valueOf(stop)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long jsonarrTrim(byte[] key, byte[] path, int start, int stop) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.JSONARRTRIM, (byte[][])new byte[][]{key, path, Protocol.toByteArray((int)start), Protocol.toByteArray((int)stop)});
        return (Long)BuilderFactory.LONG.build(obj);
    }
}

