/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairgis;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairgis.factory.GisBuilderFactory;
import com.aliyun.tair.tairgis.params.GisParams;
import com.aliyun.tair.tairgis.params.GisSearchResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairGis {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairGis(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairGis(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long gisadd(String key, String polygonName, String polygonWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISADD, new String[]{key, polygonName, polygonWktText});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long gisadd(byte[] key, byte[] polygonName, byte[] polygonWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISADD, (byte[][])new byte[][]{key, polygonName, polygonWktText});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String gisget(String key, String polygonName) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGET, new String[]{key, polygonName});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] gisget(byte[] key, byte[] polygonName) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGET, (byte[][])new byte[][]{key, polygonName});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> gissearch(String key, String pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, new String[]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> gissearch(byte[] key, byte[] pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, (byte[][])new byte[][]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GisSearchResponse> gissearch(String key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw()));
            List list = (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GisSearchResponse> gissearch(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(key, SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw()));
            List list = (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GisSearchResponse> gissearchByMember(String key, String member, double radius, GeoUnit unit, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"member"), SafeEncoder.encode((String)member), Protocol.toByteArray((double)radius), unit.getRaw()));
            List list = (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GisSearchResponse> gissearchByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(key, SafeEncoder.encode((String)"member"), member, Protocol.toByteArray((double)radius), unit.getRaw()));
            List list = (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> giscontains(String key, String pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISCONTAINS, new String[]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> giscontains(String key, String pointWktText, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISCONTAINS, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText)));
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            List rawResults = (List)result.get(1);
            List list = (List)BuilderFactory.STRING_LIST.build((Object)rawResults);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> giscontains(byte[] key, byte[] pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISCONTAINS, (byte[][])new byte[][]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> giscontains(byte[] key, byte[] pointWktText, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISCONTAINS, gisParams.getByteParams(key, pointWktText));
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            List rawResults = (List)result.get(1);
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build((Object)rawResults);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> giswithin(String key, String pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISWITHIN, new String[]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> giswithin(String key, String pointWktText, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISWITHIN, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText)));
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            List rawResults = (List)result.get(1);
            List list = (List)BuilderFactory.STRING_LIST.build((Object)rawResults);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> giswithin(byte[] key, byte[] pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISWITHIN, (byte[][])new byte[][]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> giswithin(byte[] key, byte[] pointWktText, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISWITHIN, gisParams.getByteParams(key, pointWktText));
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            List rawResults = (List)result.get(1);
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build((Object)rawResults);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> gisintersects(String key, String pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISINTERSECTS, new String[]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> gisintersects(byte[] key, byte[] pointWktText) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISINTERSECTS, (byte[][])new byte[][]{key, pointWktText});
            List result = (List)obj;
            if (null == result || 0 == result.size()) {
                HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
                return hashMap;
            }
            List rawResults = (List)result.get(1);
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String gisdel(String key, String polygonName) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISDEL, new String[]{key, polygonName});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] gisdel(byte[] key, byte[] polygonName) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISDEL, (byte[][])new byte[][]{key, polygonName});
            byte[] byArray = (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
            return byArray;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> gisgetall(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGETALL, new String[]{key});
            if (obj == null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                return hashMap;
            }
            Map map = (Map)BuilderFactory.STRING_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gisgetall(String key, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGETALL, gisParams.getByteParams(new byte[][]{SafeEncoder.encode((String)key)}));
            if (obj == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            List list = (List)BuilderFactory.STRING_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], byte[]> gisgetall(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGETALL, (byte[][])new byte[][]{key});
            if (obj == null) {
                HashMap<byte[], byte[]> hashMap = new HashMap<byte[], byte[]>();
                return hashMap;
            }
            Map map = (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
            return map;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> gisgetall(byte[] key, GisParams gisParams) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.GISGETALL, gisParams.getByteParams(new byte[][]{key}));
            if (obj == null) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            List list = (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
            return list;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

