/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.QueryBuilder;
import java.util.Objects;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder<QB>>
implements QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    public static final String BOOST = "boost";
    protected float boost = 1.0f;

    @Override
    public final float boost() {
        return this.boost;
    }

    protected final void checkNegativeBoost(float boost) {
        if (Float.compare(boost, 0.0f) < 0) {
            throw new IllegalArgumentException("negative [boost] are not allowed in [" + this.toString() + "], use a value between 0 and 1 to deboost");
        }
    }

    public final QB boost(float boost) {
        this.checkNegativeBoost(boost);
        this.boost = boost;
        return (QB)this;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBuilder other = (AbstractQueryBuilder)obj;
        return Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost)) && this.doEquals(other);
    }

    protected abstract boolean doEquals(QB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), Float.valueOf(this.boost), this.doHashCode());
    }

    protected abstract int doHashCode();

    public String toString() {
        return this.constructJSON().toString();
    }
}

