/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.aliyun.tair.tairsearch.index.query.QueryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DisMaxQueryBuilder
extends AbstractQueryBuilder<DisMaxQueryBuilder> {
    public static final String NAME = "dis_max";
    public static final float DEFAULT_TIE_BREAKER = 0.0f;
    private static final String TIE_BREAKER_FIELD = "tie_breaker";
    private static final String QUERIES_FIELD = "queries";
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();
    private float tieBreaker = 0.0f;

    public DisMaxQueryBuilder add(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner dismax query clause cannot be null");
        }
        this.queries.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> innerQueries() {
        return this.queries;
    }

    public DisMaxQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject newQueryObject = new JsonObject();
        newQueryObject.addProperty(TIE_BREAKER_FIELD, (Number)Float.valueOf(this.tieBreaker));
        JsonArray queriesJSON = new JsonArray();
        for (QueryBuilder qb : this.queries) {
            queriesJSON.add((JsonElement)qb.constructJSON());
        }
        newQueryObject.add(QUERIES_FIELD, (JsonElement)queriesJSON);
        JsonObject queryObject = new JsonObject();
        queryObject.add(NAME, (JsonElement)newQueryObject);
        return queryObject;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queries, Float.valueOf(this.tieBreaker));
    }

    @Override
    protected boolean doEquals(DisMaxQueryBuilder other) {
        return Objects.equals(this.queries, other.queries) && Objects.equals(Float.valueOf(this.tieBreaker), Float.valueOf(other.tieBreaker));
    }
}

