/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.aliyun.tair.tairsearch.index.query.Operator;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Objects;

public class MatchQueryBuilder
extends AbstractQueryBuilder<MatchQueryBuilder> {
    public static final String NAME = "match";
    public static final String OPERATOR = "operator";
    public static final String PREFIX_LENGTH = "prefix_length";
    public static final String ANALYZER = "analyzer";
    public static final String QUERY = "query";
    public static final String FUZZINESS = "fuzziness";
    public static final String MINIMUM_SHOULD_MATCH = "minimum_should_match";
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final int DEFAULT_FUZZINESS = 0;
    public static final int DEFAULT_PREFIXLENGTH = 0;
    public static final int DEFAULT_MINIMUMSHOULDMATCH = 0;
    private final String fieldName;
    private final Object value;
    private Operator operator = DEFAULT_OPERATOR;
    private String analyzer = null;
    private int fuzziness = 0;
    private int prefixLength = 0;
    private int minimumShouldMatch = 0;

    public MatchQueryBuilder(String fieldName, Object value) {
        if (fieldName == null) {
            throw new IllegalArgumentException("[match] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[match] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.value;
    }

    public MatchQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[match] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MatchQueryBuilder fuzziness(int fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public int fuzziness() {
        return this.fuzziness;
    }

    public MatchQueryBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("[match] requires prefix length to be non-negative.");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public MatchQueryBuilder minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public int minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject valueObject = new JsonObject();
        valueObject.add(QUERY, new Gson().toJsonTree(this.value));
        if (this.analyzer != null && this.analyzer.length() != 0) {
            valueObject.addProperty(ANALYZER, this.analyzer);
        }
        if (this.fuzziness != 0) {
            valueObject.addProperty(FUZZINESS, (Number)this.fuzziness);
        }
        if (this.minimumShouldMatch != 0) {
            valueObject.addProperty(MINIMUM_SHOULD_MATCH, (Number)this.minimumShouldMatch);
        }
        if (this.prefixLength != 0) {
            valueObject.addProperty(PREFIX_LENGTH, (Number)this.prefixLength);
        }
        if (this.operator != DEFAULT_OPERATOR) {
            valueObject.addProperty(OPERATOR, this.operator.toString().toLowerCase(Locale.ROOT));
        }
        JsonObject queryObject = new JsonObject();
        queryObject.add(this.fieldName, (JsonElement)valueObject);
        JsonObject newQueryObject = new JsonObject();
        newQueryObject.add(NAME, (JsonElement)queryObject);
        return newQueryObject;
    }

    @Override
    protected boolean doEquals(MatchQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.value, this.operator, this.analyzer, this.fuzziness, this.prefixLength, this.minimumShouldMatch});
    }
}

