/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations;

import com.aliyun.tair.tairsearch.search.aggregations.BucketOrder;
import com.aliyun.tair.tairsearch.search.sort.SortOrder;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Objects;

public abstract class InternalOrder
extends BucketOrder {
    static final InternalOrder COUNT_DESC = new SimpleOrder("_count", SortOrder.DESC);
    static final InternalOrder COUNT_ASC = new SimpleOrder("_count", SortOrder.ASC);
    static final InternalOrder KEY_DESC = new SimpleOrder("_key", SortOrder.DESC);
    static final InternalOrder KEY_ASC = new SimpleOrder("_key", SortOrder.ASC);

    public static boolean isCountDesc(BucketOrder order) {
        return InternalOrder.isOrder(order, COUNT_DESC);
    }

    public static boolean isKeyOrder(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_ASC) || InternalOrder.isOrder(order, KEY_DESC);
    }

    public static boolean isKeyAsc(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_ASC);
    }

    public static boolean isKeyDesc(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_DESC);
    }

    private static boolean isOrder(BucketOrder order, BucketOrder expected) {
        return order == expected;
    }

    private static class SimpleOrder
    extends InternalOrder {
        private final String key;
        private final SortOrder order;

        SimpleOrder(String key, SortOrder order) {
            this.key = key;
            this.order = order;
        }

        @Override
        public JsonObject constructJSON() {
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(this.key, this.order.toString().toLowerCase(Locale.ROOT));
            return orderObject;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.order});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleOrder other = (SimpleOrder)obj;
            return Objects.equals(this.key, other.key) && Objects.equals((Object)this.order, (Object)other.order);
        }
    }
}

