/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.builder;

import com.aliyun.tair.tairsearch.search.builder.BaseSearchSourceBuilder;
import com.aliyun.tair.tairsearch.search.sort.SortBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SearchSourceBuilder
extends BaseSearchSourceBuilder<SearchSourceBuilder> {
    public static final String FROM_FIELD = "from";
    private int from = -1;

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public SearchSourceBuilder from(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("[from] parameter cannot be negative");
        }
        this.from = from;
        return this;
    }

    public int from() {
        return this.from;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject queryObject = new JsonObject();
        if (this.size != -1) {
            queryObject.addProperty("size", (Number)this.size);
        }
        if (this.from != -1) {
            queryObject.addProperty(FROM_FIELD, (Number)this.from);
        }
        if (this.trackTotalHits) {
            queryObject.addProperty("track_total_hits", Boolean.valueOf(this.trackTotalHits));
        }
        if (this.queryBuilder != null) {
            queryObject.add("query", (JsonElement)this.queryBuilder.constructJSON());
        }
        if (this.fetchSourceContext != null) {
            queryObject.add("_source", (JsonElement)this.fetchSourceContext.constructJSON());
        }
        if (this.sorts != null) {
            JsonArray sortArray = new JsonArray();
            for (SortBuilder sort : this.sorts) {
                sortArray.add((JsonElement)sort.constructJSON());
            }
            queryObject.add("sort", (JsonElement)sortArray);
        }
        if (this.aggregations != null) {
            queryObject.add("aggs", (JsonElement)this.aggregations.constructJSON());
        }
        return queryObject;
    }
}

