/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairstring;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairstring.factory.StringBuilderFactory;
import com.aliyun.tair.tairstring.params.CasParams;
import com.aliyun.tair.tairstring.params.ExincrbyFloatParams;
import com.aliyun.tair.tairstring.params.ExincrbyParams;
import com.aliyun.tair.tairstring.params.ExsetParams;
import com.aliyun.tair.tairstring.results.ExcasResult;
import com.aliyun.tair.tairstring.results.ExgetResult;
import com.aliyun.tair.tairstring.results.ExincrbyVersionResult;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairString {
    private Jedis jedis;
    private JedisPool jedisPool;

    public TairString(Jedis jedis) {
        this.jedis = jedis;
    }

    public TairString(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    public Long cas(String key, String oldvalue, String newvalue) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long cas(byte[] key, byte[] oldvalue, byte[] newvalue) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CAS, (byte[][])new byte[][]{key, oldvalue, newvalue});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long cas(String key, String oldvalue, String newvalue, CasParams params) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long cas(byte[] key, byte[] oldvalue, byte[] newvalue, CasParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CAS, params.getByteParams(key, oldvalue, newvalue));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long cad(String key, String value) {
        return this.cad(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long cad(byte[] key, byte[] value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.CAD, (byte[][])new byte[][]{key, value});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exset(String key, String value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, new String[]{key, value});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exset(byte[] key, byte[] value) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, (byte[][])new byte[][]{key, value});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exset(String key, String value, ExsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exset(byte[] key, byte[] value, ExsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value));
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exsetVersion(String key, String value, ExsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value, "WITHVERSION"));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exsetVersion(byte[] key, byte[] value, ExsetParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value, "WITHVERSION".getBytes()));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<String> exget(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGET, new String[]{key});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<byte[]> exget(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGET, (byte[][])new byte[][]{key});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<String> exgetFlags(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGET, new String[]{key, "WITHFLAGS"});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<byte[]> exgetFlags(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGET, (byte[][])new byte[][]{key, "WITHFLAGS".getBytes()});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exsetver(String key, long version) {
        return this.exsetver(SafeEncoder.encode((String)key), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exsetver(byte[] key, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXSETVER, (byte[][])new byte[][]{key, Protocol.toByteArray((long)version)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exincrBy(String key, long incr) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exincrBy(byte[] key, long incr) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXINCRBY, (byte[][])new byte[][]{key, Protocol.toByteArray((long)incr)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exincrBy(String key, long incr, ExincrbyParams params) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exincrBy(byte[] key, long incr, ExincrbyParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXINCRBY, params.getByteParams(key, Protocol.toByteArray((long)incr)));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public ExincrbyVersionResult exincrByVersion(String key, long incr, ExincrbyParams params) {
        return this.exincrByVersion(SafeEncoder.encode((String)key), incr, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExincrbyVersionResult exincrByVersion(byte[] key, long incr, ExincrbyParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXINCRBY, params.getByteParams(key, Protocol.toByteArray((long)incr), "WITHVERSION".getBytes()));
            ExincrbyVersionResult exincrbyVersionResult = (ExincrbyVersionResult)StringBuilderFactory.EXINCRBY_VERSION_RESULT_STRING.build(obj);
            return exincrbyVersionResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double exincrByFloat(String key, Double incr) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double exincrByFloat(byte[] key, Double incr) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXINCRBYFLOAT, (byte[][])new byte[][]{key, Protocol.toByteArray((double)incr)});
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Double exincrByFloat(String key, Double incr, ExincrbyFloatParams params) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double exincrByFloat(byte[] key, Double incr, ExincrbyFloatParams params) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXINCRBYFLOAT, params.getByteParams(key, Protocol.toByteArray((double)incr)));
            Double d = (Double)BuilderFactory.DOUBLE.build(obj);
            return d;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcasResult<String> excas(String key, String newvalue, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXCAS, new String[]{key, newvalue, String.valueOf(version)});
            if (obj instanceof Long && (Long)obj == -1L) {
                ExcasResult<String> excasResult = null;
                return excasResult;
            }
            ExcasResult excasResult = (ExcasResult)StringBuilderFactory.EXCAS_RESULT_STRING.build(obj);
            return excasResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcasResult<byte[]> excas(byte[] key, byte[] newvalue, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXCAS, (byte[][])new byte[][]{key, newvalue, Protocol.toByteArray((long)version)});
            if (obj instanceof Long && (Long)obj == -1L) {
                ExcasResult<byte[]> excasResult = null;
                return excasResult;
            }
            ExcasResult excasResult = (ExcasResult)StringBuilderFactory.EXCAS_RESULT_BYTE.build(obj);
            return excasResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long excad(String key, long version) {
        return this.excad(SafeEncoder.encode((String)key), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long excad(byte[] key, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXCAD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)version)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exappend(String key, String value, String nxxx, String verabs, long version) {
        return this.exappend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exappend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXAPPEND, (byte[][])new byte[][]{key, value, SafeEncoder.encode((String)nxxx), SafeEncoder.encode((String)verabs), Protocol.toByteArray((long)version)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public Long exprepend(String key, String value, String nxxx, String verabs, long version) {
        return this.exprepend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long exprepend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXPREPEND, (byte[][])new byte[][]{key, value, SafeEncoder.encode((String)nxxx), SafeEncoder.encode((String)verabs), Protocol.toByteArray((long)version)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<String> exgae(String key, String expxwithat, long time) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGAE, new String[]{key, expxwithat, Long.toString(time)});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExgetResult<byte[]> exgae(byte[] key, String expxwithat, long time) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXGAE, (byte[][])new byte[][]{key, SafeEncoder.encode((String)expxwithat), Protocol.toByteArray((long)time)});
            ExgetResult exgetResult = (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
            return exgetResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

