/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairstring;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairstring.factory.StringBuilderFactory;
import com.aliyun.tair.tairstring.params.CasParams;
import com.aliyun.tair.tairstring.params.ExincrbyFloatParams;
import com.aliyun.tair.tairstring.params.ExincrbyParams;
import com.aliyun.tair.tairstring.params.ExsetParams;
import com.aliyun.tair.tairstring.results.ExcasResult;
import com.aliyun.tair.tairstring.results.ExgetResult;
import com.aliyun.tair.tairstring.results.ExincrbyVersionResult;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairStringCluster {
    private JedisCluster jc;

    public TairStringCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public Long cas(String key, String oldvalue, String newvalue) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue));
    }

    public Long cas(byte[] key, byte[] oldvalue, byte[] newvalue) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.CAS, (byte[][])new byte[][]{key, oldvalue, newvalue});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long cas(String key, String oldvalue, String newvalue, CasParams params) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue), params);
    }

    public Long cas(byte[] key, byte[] oldvalue, byte[] newvalue, CasParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.CAS, params.getByteParams(key, oldvalue, newvalue));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long cad(String key, String value) {
        return this.cad(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
    }

    public Long cad(byte[] key, byte[] value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.CAD, (byte[][])new byte[][]{key, value});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String exset(String key, String value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXSET, new String[]{key, value});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String exset(byte[] key, byte[] value) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXSET, (byte[][])new byte[][]{key, value});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String exset(String key, String value, ExsetParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String exset(byte[] key, byte[] value, ExsetParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public Long exsetVersion(String key, String value, ExsetParams params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value, "WITHVERSION"));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exsetVersion(byte[] key, byte[] value, ExsetParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXSET, params.getByteParams(key, value, "WITHVERSION".getBytes()));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ExgetResult<String> exget(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGET, new String[]{key});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
    }

    public ExgetResult<byte[]> exget(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGET, (byte[][])new byte[][]{key});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
    }

    public ExgetResult<String> exgetFlags(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGET, new String[]{key, "WITHFLAGS"});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
    }

    public ExgetResult<byte[]> exgetFlags(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGET, (byte[][])new byte[][]{key, "WITHFLAGS".getBytes()});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
    }

    public Long exsetver(String key, long version) {
        return this.exsetver(SafeEncoder.encode((String)key), version);
    }

    public Long exsetver(byte[] key, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXSETVER, (byte[][])new byte[][]{key, Protocol.toByteArray((long)version)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exincrBy(String key, long incr) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr);
    }

    public Long exincrBy(byte[] key, long incr) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXINCRBY, (byte[][])new byte[][]{key, Protocol.toByteArray((long)incr)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exincrBy(String key, long incr, ExincrbyParams params) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr, params);
    }

    public Long exincrBy(byte[] key, long incr, ExincrbyParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXINCRBY, params.getByteParams(key, Protocol.toByteArray((long)incr)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ExincrbyVersionResult exincrByVersion(String key, long incr, ExincrbyParams params) {
        return this.exincrByVersion(SafeEncoder.encode((String)key), incr, params);
    }

    public ExincrbyVersionResult exincrByVersion(byte[] key, long incr, ExincrbyParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXINCRBY, params.getByteParams(key, Protocol.toByteArray((long)incr), "WITHVERSION".getBytes()));
        return (ExincrbyVersionResult)StringBuilderFactory.EXINCRBY_VERSION_RESULT_STRING.build(obj);
    }

    public Double exincrByFloat(String key, Double incr) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr);
    }

    public Double exincrByFloat(byte[] key, Double incr) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXINCRBYFLOAT, (byte[][])new byte[][]{key, Protocol.toByteArray((double)incr)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double exincrByFloat(String key, Double incr, ExincrbyFloatParams params) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr, params);
    }

    public Double exincrByFloat(byte[] key, Double incr, ExincrbyFloatParams params) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXINCRBYFLOAT, params.getByteParams(key, Protocol.toByteArray((double)incr)));
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public ExcasResult<String> excas(String key, String newvalue, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXCAS, new String[]{key, newvalue, String.valueOf(version)});
        return (ExcasResult)StringBuilderFactory.EXCAS_RESULT_STRING.build(obj);
    }

    public ExcasResult<byte[]> excas(byte[] key, byte[] newvalue, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXCAS, (byte[][])new byte[][]{key, newvalue, Protocol.toByteArray((long)version)});
        return (ExcasResult)StringBuilderFactory.EXCAS_RESULT_BYTE.build(obj);
    }

    public Long excad(String key, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXCAD, new String[]{key, String.valueOf(version)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long excad(byte[] key, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXCAD, (byte[][])new byte[][]{key, Protocol.toByteArray((long)version)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exappend(String key, String value, String nxxx, String verabs, long version) {
        return this.exappend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    public Long exappend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXAPPEND, (byte[][])new byte[][]{key, value, SafeEncoder.encode((String)nxxx), SafeEncoder.encode((String)verabs), Protocol.toByteArray((long)version)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long exprepend(String key, String value, String nxxx, String verabs, long version) {
        return this.exprepend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    public Long exprepend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXPREPEND, (byte[][])new byte[][]{key, value, SafeEncoder.encode((String)nxxx), SafeEncoder.encode((String)verabs), Protocol.toByteArray((long)version)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ExgetResult<String> exgae(String key, String expxwithat, long time) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGAE, new String[]{key, expxwithat, Long.toString(time)});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_STRING.build(obj);
    }

    public ExgetResult<byte[]> exgae(byte[] key, String expxwithat, long time) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.EXGAE, (byte[][])new byte[][]{key, SafeEncoder.encode((String)expxwithat), Protocol.toByteArray((long)time)});
        return (ExgetResult)StringBuilderFactory.EXGET_RESULT_BYTE.build(obj);
    }
}

