/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairstring;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairstring.factory.StringBuilderFactory;
import com.aliyun.tair.tairstring.params.CasParams;
import com.aliyun.tair.tairstring.params.ExincrbyFloatParams;
import com.aliyun.tair.tairstring.params.ExincrbyParams;
import com.aliyun.tair.tairstring.params.ExsetParams;
import com.aliyun.tair.tairstring.results.ExcasResult;
import com.aliyun.tair.tairstring.results.ExgetResult;
import com.aliyun.tair.tairstring.results.ExincrbyVersionResult;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairStringPipeline
extends Pipeline {
    public TairStringPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<Long> cas(String key, String oldvalue, String newvalue) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue));
    }

    public Response<Long> cas(byte[] key, byte[] oldvalue, byte[] newvalue) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CAS).add(key).add(oldvalue).add(newvalue), BuilderFactory.LONG));
    }

    public Response<Long> cas(String key, String oldvalue, String newvalue, CasParams params) {
        return this.cas(SafeEncoder.encode((String)key), SafeEncoder.encode((String)oldvalue), SafeEncoder.encode((String)newvalue), params);
    }

    public Response<Long> cas(byte[] key, byte[] oldvalue, byte[] newvalue, CasParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CAS).addObjects((Object[])params.getByteParams(key, oldvalue, newvalue)), BuilderFactory.LONG));
    }

    public Response<Long> cad(String key, String value) {
        return this.cad(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
    }

    public Response<Long> cad(byte[] key, byte[] value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.CAD).add(key).add(value), BuilderFactory.LONG));
    }

    public Response<String> exset(String key, String value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).add(key).add(value), BuilderFactory.STRING));
    }

    public Response<String> exset(byte[] key, byte[] value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).add(key).add(value), BuilderFactory.STRING));
    }

    public Response<String> exset(String key, String value, ExsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).addObjects((Object[])params.getByteParams(key, value)), BuilderFactory.STRING));
    }

    public Response<String> exset(byte[] key, byte[] value, ExsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).addObjects((Object[])params.getByteParams(key, value)), BuilderFactory.STRING));
    }

    public Response<Long> exsetVersion(String key, String value, ExsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).addObjects((Object[])params.getByteParams(key, value, "WITHVERSION")), BuilderFactory.LONG));
    }

    public Response<Long> exsetVersion(byte[] key, byte[] value, ExsetParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSET).addObjects((Object[])params.getByteParams(key, value, "WITHVERSION".getBytes())), BuilderFactory.LONG));
    }

    public Response<ExgetResult<String>> exget(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGET).add(key), StringBuilderFactory.EXGET_RESULT_STRING));
    }

    public Response<ExgetResult<byte[]>> exget(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGET).add(key), StringBuilderFactory.EXGET_RESULT_BYTE));
    }

    public Response<ExgetResult<String>> exgetFlags(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGET).add(key).add("WITHFLAGS"), StringBuilderFactory.EXGET_RESULT_STRING));
    }

    public Response<ExgetResult<byte[]>> exgetFlags(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGET).add(key).add("WITHFLAGS"), StringBuilderFactory.EXGET_RESULT_BYTE));
    }

    public Response<Long> exsetver(String key, long version) {
        return this.exsetver(SafeEncoder.encode((String)key), version);
    }

    public Response<Long> exsetver(byte[] key, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXSETVER).add(key).add(version), BuilderFactory.LONG));
    }

    public Response<Long> exincrBy(String key, long incr) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr);
    }

    public Response<Long> exincrBy(byte[] key, long incr) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXINCRBY).add(key).add(incr), BuilderFactory.LONG));
    }

    public Response<Long> exincrBy(String key, long incr, ExincrbyParams params) {
        return this.exincrBy(SafeEncoder.encode((String)key), incr, params);
    }

    public Response<Long> exincrBy(byte[] key, long incr, ExincrbyParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXINCRBY).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)incr))), BuilderFactory.LONG));
    }

    public Response<ExincrbyVersionResult> exincrByVersion(String key, long incr, ExincrbyParams params) {
        return this.exincrByVersion(SafeEncoder.encode((String)key), incr, params);
    }

    public Response<ExincrbyVersionResult> exincrByVersion(byte[] key, long incr, ExincrbyParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXINCRBY).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((long)incr), "WITHVERSION".getBytes())), StringBuilderFactory.EXINCRBY_VERSION_RESULT_STRING));
    }

    public Response<Double> exincrByFloat(String key, Double incr) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr);
    }

    public Response<Double> exincrByFloat(byte[] key, Double incr) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXINCRBYFLOAT).add(key).add((Object)incr), BuilderFactory.DOUBLE));
    }

    public Response<Double> exincrByFloat(String key, Double incr, ExincrbyFloatParams params) {
        return this.exincrByFloat(SafeEncoder.encode((String)key), incr, params);
    }

    public Response<Double> exincrByFloat(byte[] key, Double incr, ExincrbyFloatParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXINCRBYFLOAT).addObjects((Object[])params.getByteParams(key, Protocol.toByteArray((double)incr))), BuilderFactory.DOUBLE));
    }

    public Response<ExcasResult<String>> excas(String key, String value, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXCAS).add(key).add(value).add(version), StringBuilderFactory.EXCAS_RESULT_STRING));
    }

    public Response<ExcasResult<byte[]>> excas(byte[] key, byte[] value, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXCAS).add(key).add(value).add(version), StringBuilderFactory.EXCAS_RESULT_BYTE));
    }

    public Response<Long> excad(String key, long version) {
        return this.excad(SafeEncoder.encode((String)key), version);
    }

    public Response<Long> excad(byte[] key, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXCAD).add(key).add(version), BuilderFactory.LONG));
    }

    public Response<Long> exappend(String key, String value, String nxxx, String verabs, long version) {
        return this.exappend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    public Response<Long> exappend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXAPPEND).add(key).add(value).add(nxxx).add(verabs).add(version), BuilderFactory.LONG));
    }

    public Response<Long> exprepend(String key, String value, String nxxx, String verabs, long version) {
        return this.exprepend(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value), nxxx, verabs, version);
    }

    public Response<Long> exprepend(byte[] key, byte[] value, String nxxx, String verabs, long version) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXPREPEND).add(key).add(value).add(nxxx).add(verabs).add(version), BuilderFactory.LONG));
    }

    public Response<ExgetResult<String>> exgae(String key, String expxwithat, long time) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGAE).add(key).add(expxwithat).add(time), StringBuilderFactory.EXGET_RESULT_STRING));
    }

    public Response<ExgetResult<byte[]>> exgae(byte[] key, String expxwithat, long time) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXGAE).add(key).add(expxwithat).add(time), StringBuilderFactory.EXGET_RESULT_BYTE));
    }
}

