/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairvector;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairvector.factory.VectorBuilderFactory;
import com.aliyun.tair.tairvector.params.DistanceMethod;
import com.aliyun.tair.tairvector.params.HscanParams;
import com.aliyun.tair.tairvector.params.IndexAlgorithm;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairVectorPipeline
extends Pipeline {
    public TairVectorPipeline(Jedis jedis) {
        super(jedis);
    }

    public void quit() {
    }

    public Response<String> tvscreateindex(String index, int dims, IndexAlgorithm algorithm, DistanceMethod method, String ... attrs) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSCREATEINDEX).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), SafeEncoder.encodeMany((String[])attrs))), BuilderFactory.STRING));
    }

    public Response<byte[]> tvscreateindex(byte[] index, int dims, IndexAlgorithm algorithm, DistanceMethod method, byte[] ... params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSCREATEINDEX).addObjects((Object[])JoinParameters.joinParameters(index, Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), params)), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<Map<String, String>> tvsgetindex(String index) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSGETINDEX).add(SafeEncoder.encode((String)index)), BuilderFactory.STRING_MAP));
    }

    public Response<Map<byte[], byte[]>> tvsgetindex(byte[] index) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSGETINDEX).add(index), Jedis3BuilderFactory.BYTE_ARRAY_MAP));
    }

    public Response<Long> tvsdelindex(String index) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDELINDEX).add(SafeEncoder.encode((String)index)), BuilderFactory.LONG));
    }

    public Response<Long> tvsdelindex(byte[] index) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDELINDEX).add(index), BuilderFactory.LONG));
    }

    public Response<ScanResult<String>> tvsscanindex(Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSSCANINDEX).addObjects(args), VectorBuilderFactory.SCAN_CURSOR_STRING));
    }

    public Response<Long> tvshset(String index, String entityid, String vector, String ... params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHSET).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)"VECTOR"), SafeEncoder.encode((String)vector), SafeEncoder.encodeMany((String[])params))), BuilderFactory.LONG));
    }

    public Response<Long> tvshset(byte[] index, byte[] entityid, byte[] vector, byte[] ... params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHSET).addObjects((Object[])JoinParameters.joinParameters(index, entityid, SafeEncoder.encode((String)"VECTOR"), vector, params)), BuilderFactory.LONG));
    }

    public Response<Map<String, String>> tvshgetall(String index, String entityid) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHGETALL).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)entityid)), BuilderFactory.STRING_MAP));
    }

    public Response<Map<byte[], byte[]>> tvshgetall(byte[] index, byte[] entityid) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHGETALL).add(index).add(entityid), Jedis3BuilderFactory.BYTE_ARRAY_MAP));
    }

    public Response<List<String>> tvshmget(String index, String entityid, String ... attrs) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHMGET).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encodeMany((String[])attrs))), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> tvshmget(byte[] index, byte[] entityid, byte[] ... attrs) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHMGET).addObjects((Object[])JoinParameters.joinParameters(index, entityid, attrs)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<Long> tvsdel(String index, String entityid) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDEL).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)entityid)), BuilderFactory.LONG));
    }

    public Response<Long> tvsdel(byte[] index, byte[] entityid) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDEL).add(index).add(entityid), BuilderFactory.LONG));
    }

    public Response<Long> tvsdel(String index, String ... entityids) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDEL).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encodeMany((String[])entityids))), BuilderFactory.LONG));
    }

    public Response<Long> tvsdel(byte[] index, byte[] ... entityids) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSDEL).addObjects((Object[])JoinParameters.joinParameters(index, entityids)), BuilderFactory.LONG));
    }

    public Response<Long> tvshdel(String index, String entityid, String ... attrs) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHDEL).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encodeMany((String[])attrs))), BuilderFactory.LONG));
    }

    public Response<Long> tvshdel(byte[] index, byte[] entityid, byte[] ... attrs) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHDEL).addObjects((Object[])JoinParameters.joinParameters(index, entityid, attrs)), BuilderFactory.LONG));
    }

    public Response<ScanResult<String>> tvsscan(String index, Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSSCAN).addObjects(args), VectorBuilderFactory.SCAN_CURSOR_STRING));
    }

    public Response<ScanResult<byte[]>> tvsscan(byte[] index, Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSSCAN).addObjects(args), VectorBuilderFactory.SCAN_CURSOR_BYTE));
    }

    public Response<VectorBuilderFactory.Knn<String>> tvsknnsearch(String index, Long topn, String vector, String ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, "", params);
    }

    public Response<VectorBuilderFactory.Knn<byte[]>> tvsknnsearch(byte[] index, Long topn, byte[] vector, byte[] ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, SafeEncoder.encode((String)""), params);
    }

    public Response<VectorBuilderFactory.Knn<String>> tvsknnsearchfilter(String index, Long topn, String vector, String pattern, String ... params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSKNNSEARCH).addObjects((Object[])JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((long)topn), SafeEncoder.encode((String)vector), SafeEncoder.encode((String)pattern), SafeEncoder.encodeMany((String[])params))), VectorBuilderFactory.STRING_KNN_RESULT));
    }

    public Response<VectorBuilderFactory.Knn<byte[]>> tvsknnsearchfilter(byte[] index, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSKNNSEARCH).addObjects((Object[])JoinParameters.joinParameters(index, Protocol.toByteArray((long)topn), vector, pattern, params)), VectorBuilderFactory.BYTE_KNN_RESULT));
    }

    public Response<VectorBuilderFactory.KnnField<String>> tvsknnsearchfield(String index, Long topn, String vector, Collection<String> fields, String ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, "", params);
    }

    public Response<VectorBuilderFactory.KnnField<byte[]>> tvsknnsearchfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, SafeEncoder.encode((String)""), params);
    }

    public Response<VectorBuilderFactory.KnnField<String>> tvsknnsearchfilterfield(String index, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)topn));
        args.add(SafeEncoder.encode((String)vector));
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
        }
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(SafeEncoder::encode).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD).addObjects(args), VectorBuilderFactory.STRING_KNNFIELD_RESULT));
    }

    public Response<VectorBuilderFactory.KnnField<byte[]>> tvsknnsearchfilterfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)topn));
        args.add(vector);
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields);
        }
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD).addObjects(args), VectorBuilderFactory.BYTE_KNNFIELD_RESULT));
    }

    public Response<Collection<VectorBuilderFactory.Knn<String>>> tvsmknnsearch(String index, Long topn, Collection<String> vectors, String ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, "", params);
    }

    public Response<Collection<VectorBuilderFactory.Knn<byte[]>>> tvsmknnsearch(byte[] index, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, SafeEncoder.encode((String)""), params);
    }

    public Response<Collection<VectorBuilderFactory.Knn<String>>> tvsmknnsearchfilter(String index, Long topn, Collection<String> vectors, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors.stream().map(vector -> SafeEncoder.encode((String)vector)).collect(Collectors.toList()));
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMKNNSEARCH).addObjects(args), VectorBuilderFactory.STRING_KNN_BATCH_RESULT));
    }

    public Response<Collection<VectorBuilderFactory.Knn<byte[]>>> tvsmknnsearchfilter(byte[] index, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors);
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMKNNSEARCH).addObjects(args), VectorBuilderFactory.BYTE_KNN_BATCH_RESULT));
    }

    public Response<VectorBuilderFactory.Knn<String>> tvsmindexknnsearch(Collection<String> indexs, Long topn, String vector, String ... params) {
        return this.tvsmindexknnsearchfilter(indexs, topn, vector, "", params);
    }

    public Response<VectorBuilderFactory.Knn<byte[]>> tvsmindexknnsearch(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] ... params) {
        return this.tvsmindexknnsearchfilter(indexs, topn, vector, SafeEncoder.encode((String)""), params);
    }

    public Response<VectorBuilderFactory.Knn<String>> tvsmindexknnsearchfilter(Collection<String> indexs, Long topn, String vector, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs.stream().map(index -> SafeEncoder.encode((String)index)).collect(Collectors.toList()));
        args.add(Protocol.toByteArray((long)topn));
        args.add(SafeEncoder.encode((String)vector));
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCH).addObjects(args), VectorBuilderFactory.STRING_KNN_RESULT));
    }

    public Response<VectorBuilderFactory.Knn<byte[]>> tvsmindexknnsearchfilter(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs);
        args.add(Protocol.toByteArray((long)topn));
        args.add(vector);
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCH).addObjects(args), VectorBuilderFactory.BYTE_KNN_RESULT));
    }

    public Response<VectorBuilderFactory.KnnField<String>> tvsmindexknnsearchField(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String ... params) {
        return this.tvsmindexknnsearchfilterfield(indexs, topn, vector, fields, "", params);
    }

    public Response<VectorBuilderFactory.KnnField<byte[]>> tvsmindexknnsearchField(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return this.tvsmindexknnsearchfilterfield(indexs, topn, vector, fields, SafeEncoder.encode((String)""), params);
    }

    public Response<VectorBuilderFactory.KnnField<String>> tvsmindexknnsearchfilterfield(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
        args.add(Protocol.toByteArray((long)topn));
        args.add(SafeEncoder.encode((String)vector));
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
        }
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(SafeEncoder::encode).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCHFIELD).addObjects(args), VectorBuilderFactory.STRING_KNNFIELD_RESULT));
    }

    public Response<VectorBuilderFactory.KnnField<byte[]>> tvsmindexknnsearchfilterfield(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs);
        args.add(Protocol.toByteArray((long)topn));
        args.add(vector);
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields);
        }
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXKNNSEARCHFIELD).addObjects(args), VectorBuilderFactory.BYTE_KNNFIELD_RESULT));
    }

    public Response<Collection<VectorBuilderFactory.Knn<String>>> tvsmindexmknnsearch(Collection<String> indexs, Long topn, Collection<String> vectors, String ... params) {
        return this.tvsmindexmknnsearchfilter(indexs, topn, vectors, "", params);
    }

    public Response<Collection<VectorBuilderFactory.Knn<byte[]>>> tvsmindexmknnsearch(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return this.tvsmindexmknnsearchfilter(indexs, topn, vectors, SafeEncoder.encode((String)""), params);
    }

    public Response<Collection<VectorBuilderFactory.Knn<String>>> tvsmindexmknnsearchfilter(Collection<String> indexs, Long topn, Collection<String> vectors, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs.stream().map(index -> SafeEncoder.encode((String)index)).collect(Collectors.toList()));
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors.stream().map(vector -> SafeEncoder.encode((String)vector)).collect(Collectors.toList()));
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXMKNNSEARCH).addObjects(args), VectorBuilderFactory.STRING_KNN_BATCH_RESULT));
    }

    public Response<Collection<VectorBuilderFactory.Knn<byte[]>>> tvsmindexmknnsearchfilter(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((int)indexs.size()));
        args.addAll(indexs);
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors);
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSMINDEXMKNNSEARCH).addObjects(args), VectorBuilderFactory.BYTE_KNN_BATCH_RESULT));
    }

    public Response<Long> tvshincrby(String index, String entityid, String field, long value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHINCRBY).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)entityid)).add(SafeEncoder.encode((String)field)).add(Protocol.toByteArray((long)value)), BuilderFactory.LONG));
    }

    public Response<Long> tvshincrby(byte[] index, byte[] entityid, byte[] field, long value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHINCRBY).add(index).add(entityid).add(field).add(Protocol.toByteArray((long)value)), BuilderFactory.LONG));
    }

    public Response<Double> tvshincrbyfloat(String index, String entityid, String field, double value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)entityid)).add(SafeEncoder.encode((String)field)).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<Double> tvshincrbyfloat(byte[] index, byte[] entityid, byte[] field, double value) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT).add(index).add(entityid).add(field).add(Protocol.toByteArray((double)value)), BuilderFactory.DOUBLE));
    }

    public Response<VectorBuilderFactory.Knn<String>> tvsgetdistance(String index, String vector, Collection<String> keys, Long topn, Float max_dist, String filter) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)vector));
        args.add(Protocol.toByteArray((int)keys.size()));
        args.addAll(keys.stream().map(key -> SafeEncoder.encode((String)key)).collect(Collectors.toList()));
        if (topn != null) {
            args.add(SafeEncoder.encode((String)"TOPN"));
            args.add(Protocol.toByteArray((long)topn));
        }
        if (max_dist != null) {
            args.add(SafeEncoder.encode((String)"MAX_DIST"));
            args.add(Protocol.toByteArray((double)max_dist.floatValue()));
        }
        if (filter != null) {
            args.add(SafeEncoder.encode((String)"FILTER"));
            args.add(SafeEncoder.encode((String)filter));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSGETDISTANCE).addObjects(args), VectorBuilderFactory.STRING_KNN_RESULT));
    }

    public Response<VectorBuilderFactory.Knn<byte[]>> tvsgetdistance(byte[] index, byte[] vector, Collection<byte[]> keys, Long topn, Float max_dist, byte[] filter) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(vector);
        args.add(Protocol.toByteArray((int)keys.size()));
        args.addAll(keys);
        if (topn != null) {
            args.add(SafeEncoder.encode((String)"TOPN"));
            args.add(Protocol.toByteArray((long)topn));
        }
        if (max_dist != null) {
            args.add(SafeEncoder.encode((String)"MAX_DIST"));
            args.add(Protocol.toByteArray((double)max_dist.floatValue()));
        }
        if (filter != null) {
            args.add(SafeEncoder.encode((String)"FILTER"));
            args.add(filter);
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSGETDISTANCE).addObjects(args), VectorBuilderFactory.BYTE_KNN_RESULT));
    }

    public Response<Boolean> tvshexpire(String index, String key, int seconds) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIRE).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((int)seconds)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshexpire(byte[] index, byte[] key, int seconds) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIRE).add(index).add(key).add(Protocol.toByteArray((int)seconds)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshpexpire(String index, String key, int milliseconds) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIRE).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((int)milliseconds)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshpexpire(byte[] index, byte[] key, int milliseconds) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIRE).add(index).add(key).add(Protocol.toByteArray((int)milliseconds)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshexpireAt(String index, String key, long unixTime) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIREAT).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)unixTime)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshexpireAt(byte[] index, byte[] key, long unixTime) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIREAT).add(index).add(key).add(Protocol.toByteArray((long)unixTime)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshpexpireAt(String index, String key, long unixTime) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIREAT).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)unixTime)), BuilderFactory.BOOLEAN));
    }

    public Response<Boolean> tvshpexpireAt(byte[] index, byte[] key, long unixTime) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIREAT).add(index).add(key).add(Protocol.toByteArray((long)unixTime)), BuilderFactory.BOOLEAN));
    }

    public Response<Long> tvshttl(String index, String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHTTL).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)), BuilderFactory.LONG));
    }

    public Response<Long> tvshttl(byte[] index, byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHTTL).add(index).add(key), BuilderFactory.LONG));
    }

    public Response<Long> tvshpttl(String index, String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPTTL).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)), BuilderFactory.LONG));
    }

    public Response<Long> tvshpttl(byte[] index, byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPTTL).add(index).add(key), BuilderFactory.LONG));
    }

    public Response<Long> tvshexpiretime(String index, String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIRETIME).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)), BuilderFactory.LONG));
    }

    public Response<Long> tvshexpiretime(byte[] index, byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHEXPIRETIME).add(index).add(key), BuilderFactory.LONG));
    }

    public Response<Long> tvshpexpiretime(String index, String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIRETIME).add(SafeEncoder.encode((String)index)).add(SafeEncoder.encode((String)key)), BuilderFactory.LONG));
    }

    public Response<Long> tvshpexpiretime(byte[] index, byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.TVSHPEXPIRETIME).add(index).add(key), BuilderFactory.LONG));
    }
}

