/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairvector.factory;

import com.aliyun.tair.jedis3.ScanResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import redis.clients.jedis.Builder;
import redis.clients.jedis.util.SafeEncoder;

public class VectorBuilderFactory {
    public static final String VECTOR_TAG = "VECTOR";
    public static final Builder<Knn<String>> STRING_KNN_RESULT = new Builder<Knn<String>>(){

        public Knn<String> build(Object data) {
            Iterator iterator = ((List)data).iterator();
            Knn<String> results = new Knn<String>();
            while (iterator.hasNext()) {
                results.add(new KnnItem<String>(SafeEncoder.encode((byte[])((byte[])iterator.next())), Double.valueOf(SafeEncoder.encode((byte[])((byte[])iterator.next())))));
            }
            return results;
        }

        public String toString() {
            return "Knn<String>";
        }
    };
    public static final Builder<Knn<byte[]>> BYTE_KNN_RESULT = new Builder<Knn<byte[]>>(){

        public Knn<byte[]> build(Object data) {
            Iterator iterator = ((List)data).iterator();
            Knn<byte[]> results = new Knn<byte[]>();
            while (iterator.hasNext()) {
                results.add(new KnnItem(iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])((byte[])iterator.next())))));
            }
            return results;
        }

        public String toString() {
            return "Knn<Byte[]>";
        }
    };
    public static final Builder<Collection<Knn<String>>> STRING_KNN_BATCH_RESULT = new Builder<Collection<Knn<String>>>(){

        public Collection<Knn<String>> build(Object data) {
            ArrayList<Knn<String>> results = new ArrayList<Knn<String>>();
            List resp = (List)data;
            resp.forEach(knn -> results.add((Knn<String>)STRING_KNN_RESULT.build(knn)));
            return results;
        }

        public String toString() {
            return "Collection<Knn<String>>";
        }
    };
    public static final Builder<Collection<Knn<byte[]>>> BYTE_KNN_BATCH_RESULT = new Builder<Collection<Knn<byte[]>>>(){

        public Collection<Knn<byte[]>> build(Object data) {
            ArrayList<Knn<byte[]>> results = new ArrayList<Knn<byte[]>>();
            List resp = (List)data;
            resp.forEach(knn -> results.add((Knn<byte[]>)BYTE_KNN_RESULT.build(knn)));
            return results;
        }

        public String toString() {
            return "Collection<Knn<String>>";
        }
    };
    public static final Builder<KnnField<String>> STRING_KNNFIELD_RESULT = new Builder<KnnField<String>>(){

        public KnnField<String> build(Object data) {
            KnnField<String> results = new KnnField<String>();
            List resp = (List)data;
            resp.forEach(knnField -> {
                List knnFieldByte = (List)knnField;
                Iterator iterator = knnFieldByte.iterator();
                String id = SafeEncoder.encode((byte[])((byte[])iterator.next()));
                double score = Double.parseDouble(SafeEncoder.encode((byte[])((byte[])iterator.next())));
                String index = knnFieldByte.size() % 2 == 0 ? "" : SafeEncoder.encode((byte[])((byte[])iterator.next()));
                TreeMap<String, String> fields = new TreeMap<String, String>();
                while (iterator.hasNext()) {
                    fields.put(SafeEncoder.encode((byte[])((byte[])iterator.next())), SafeEncoder.encode((byte[])((byte[])iterator.next())));
                }
                results.add(new KnnFieldItem<String>(id, score, index, fields));
            });
            return results;
        }

        public String toString() {
            return "KnnField<String>";
        }
    };
    static final Comparator<byte[]> byteArrComparator = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] a, byte[] b) {
            int minLength = Math.min(a.length, b.length);
            for (int i = 0; i < minLength; ++i) {
                int aByte = a[i] & 0xFF;
                int bByte = b[i] & 0xFF;
                if (aByte == bByte) continue;
                return aByte - bByte;
            }
            return a.length - b.length;
        }
    };
    public static final Builder<KnnField<byte[]>> BYTE_KNNFIELD_RESULT = new Builder<KnnField<byte[]>>(){

        public KnnField<byte[]> build(Object data) {
            KnnField<byte[]> results = new KnnField<byte[]>();
            List resp = (List)data;
            resp.forEach(knnField -> {
                List knnFieldByte = (List)knnField;
                Iterator iterator = knnFieldByte.iterator();
                byte[] id = (byte[])iterator.next();
                double score = Double.parseDouble(SafeEncoder.encode((byte[])((byte[])iterator.next())));
                byte[] index = knnFieldByte.size() % 2 == 0 ? SafeEncoder.encode((String)"") : (byte[])iterator.next();
                TreeMap fields = new TreeMap(byteArrComparator);
                while (iterator.hasNext()) {
                    fields.put((byte[])iterator.next(), iterator.next());
                }
                results.add(new KnnFieldItem<byte[]>(id, score, index, fields));
            });
            return results;
        }

        public String toString() {
            return "KnnField<Byte[]>";
        }
    };
    public static final Builder<ScanResult<String>> SCAN_CURSOR_STRING = new Builder<ScanResult<String>>(){

        public ScanResult<String> build(Object data) {
            if (data == null) {
                return null;
            }
            List result = (List)data;
            String newcursor = new String((byte[])result.get(0));
            ArrayList<String> results = new ArrayList<String>();
            List rawResults = (List)result.get(1);
            Iterator iterator = rawResults.iterator();
            while (iterator.hasNext()) {
                results.add(SafeEncoder.encode((byte[])((byte[])iterator.next())));
            }
            return new ScanResult<String>(newcursor, results);
        }

        public String toString() {
            return "scan_index_string";
        }
    };
    public static final Builder<ScanResult<byte[]>> SCAN_CURSOR_BYTE = new Builder<ScanResult<byte[]>>(){

        public ScanResult<byte[]> build(Object data) {
            if (data == null) {
                return null;
            }
            List result = (List)data;
            byte[] newcursor = (byte[])result.get(0);
            return new ScanResult<byte[]>(newcursor, (List)result.get(1));
        }

        public String toString() {
            return "scan_index_byte";
        }
    };

    public static class KnnField<T> {
        private Collection<KnnFieldItem<T>> knnFieldItems = new ArrayList<KnnFieldItem<T>>();

        public void add(KnnFieldItem item) {
            this.knnFieldItems.add(item);
        }

        public Collection<KnnFieldItem<T>> getKnnResults() {
            return this.knnFieldItems;
        }

        public String toString() {
            return this.knnFieldItems.toString();
        }
    }

    public static class KnnFieldItem<T> {
        private T id;
        private double score;
        private T index;
        private Map<T, T> fields;

        public KnnFieldItem(T id, double score, T index, Map<T, T> fields) {
            this.id = id;
            this.score = score;
            this.index = index;
            this.fields = fields;
        }

        public T getId() {
            return this.id;
        }

        public double getScore() {
            return this.score;
        }

        public T getIndex() {
            return this.index;
        }

        public Map<T, T> getFields() {
            return this.fields;
        }

        public String toString() {
            return "id =" + this.id + ", score =" + this.score + ", index=" + this.index + ", fields=" + this.fields + ";";
        }
    }

    public static class Knn<T> {
        private Collection<KnnItem<T>> knnItems = new ArrayList<KnnItem<T>>();

        public void add(KnnItem item) {
            this.knnItems.add(item);
        }

        public Collection<KnnItem<T>> getKnnResults() {
            return this.knnItems;
        }

        public String toString() {
            return this.knnItems.toString();
        }
    }

    public static class KnnItem<T> {
        private T id;
        private double score;

        public KnnItem(T id, double score) {
            this.id = id;
            this.score = score;
        }

        public T getId() {
            return this.id;
        }

        public double getScore() {
            return this.score;
        }

        public String toString() {
            return "id =" + this.id + ", score =" + this.score + ";";
        }
    }
}

