/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairzset;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairzset.LeaderBoard;
import com.aliyun.tair.tairzset.LeaderData;
import com.aliyun.tair.tairzset.params.RankParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;

public class DistributedLeaderBoard {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLeaderBoard.class);
    private static final String CH = "CH";
    private static final String WITHSCORES = "WITHSCORES";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final int DEFAULT_SHARDKEY_SIZE = 10;
    private static final boolean DEFAULT_REVERSE = false;
    private static final boolean DEFAULT_USE_ZERO_INDEX = true;
    public static final boolean DEFAULT_QUERY_RANK_FROM_REDIS = false;
    private final String name;
    private final byte[] nameBinary;
    private final JedisPool jedisPool;
    private final int shardKeySize;
    private final int pageSize;
    private final boolean reverse;
    private final boolean useZeroIndexForRank;
    private final boolean queryRankFromRedis;

    public DistributedLeaderBoard(String name, JedisPool jedisPool) {
        this(name, jedisPool, 10);
    }

    public DistributedLeaderBoard(String name, JedisPool jedisPool, int shardKeySize) {
        this(name, jedisPool, shardKeySize, 10);
    }

    public DistributedLeaderBoard(String name, JedisPool jedisPool, int shardKeySize, int pageSize) {
        this(name, jedisPool, shardKeySize, pageSize, false);
    }

    public DistributedLeaderBoard(String name, JedisPool jedisPool, int shardKeySize, int pageSize, boolean reverse) {
        this(name, jedisPool, shardKeySize, pageSize, reverse, true);
    }

    public DistributedLeaderBoard(String name, JedisPool jedisPool, int shardKeySize, int pageSize, boolean reverse, boolean useZeroIndexForRank) {
        this(name, jedisPool, shardKeySize, pageSize, reverse, useZeroIndexForRank, false);
    }

    public DistributedLeaderBoard(String name, JedisPool jedisPool, int shardKeySize, int pageSize, boolean reverse, boolean useZeroIndexForRank, boolean queryRankFromRedis) {
        this.name = name;
        this.nameBinary = SafeEncoder.encode((String)name);
        this.jedisPool = jedisPool;
        this.shardKeySize = shardKeySize;
        this.pageSize = pageSize;
        this.reverse = reverse;
        this.useZeroIndexForRank = useZeroIndexForRank;
        this.queryRankFromRedis = queryRankFromRedis;
    }

    private String crcKeyByMember(String member) {
        int index = JedisClusterCRC16.getSlot((String)member) % this.shardKeySize;
        return this.name + "_" + index;
    }

    private String crcKeyByMember(byte[] member) {
        int index = JedisClusterCRC16.getSlot((byte[])member) % this.shardKeySize;
        return this.name + "_" + index;
    }

    private String joinKeyAndIndex(int index) {
        return this.name + "_" + index;
    }

    public Boolean addMember(String member, String scores) {
        return this.addMember(SafeEncoder.encode((String)member), SafeEncoder.encode((String)scores));
    }

    public Boolean addMember(String member, double ... scores) {
        return this.addMember(SafeEncoder.encode((String)member), SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)));
    }

    public Boolean addMember(byte[] member, double ... scores) {
        return this.addMember(member, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)));
    }

    public Boolean addMember(byte[] member, byte[] score) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{SafeEncoder.encode((String)this.crcKeyByMember(member)), SafeEncoder.encode((String)CH), score, member});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
    }

    public List<Boolean> addMember(Map<String, String> memberScores) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (Map.Entry<String, String> entry : memberScores.entrySet()) {
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{SafeEncoder.encode((String)this.crcKeyByMember(entry.getKey())), SafeEncoder.encode((String)CH), SafeEncoder.encode((String)entry.getValue()), SafeEncoder.encode((String)entry.getKey())});
            }
            List objs = p.syncAndReturnAll();
            for (Object obj : objs) {
                results.add((Boolean)BuilderFactory.BOOLEAN.build(obj));
            }
        }
        return results;
    }

    public String incrScoreFor(String member, String increment) {
        return this.incrScoreFor(SafeEncoder.encode((String)member), SafeEncoder.encode((String)increment));
    }

    public String incrScoreFor(byte[] member, byte[] increment) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)this.crcKeyByMember(member)), increment, member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
    }

    public Long removeMember(String member) {
        return this.removeMember(SafeEncoder.encode((String)member));
    }

    public Long removeMember(byte[] member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREM, (byte[][])new byte[][]{SafeEncoder.encode((String)this.crcKeyByMember(member)), member});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public List<LeaderData> retrieveMember(long startOffset, long endOffset) {
        List<LeaderData> leaderDataList = this.top(endOffset + 1L);
        return leaderDataList.subList((int)startOffset, (int)endOffset + 1);
    }

    public Long totalMembers() {
        long rank = 0L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZCARD, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i))});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                if (objs.get(i) == null) {
                    LOGGER.error("Could not find key: {}", (Object)SafeEncoder.encode((String)this.joinKeyAndIndex(i)));
                    continue;
                }
                rank += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        return rank;
    }

    public Long totalPages() {
        return (long)Math.ceil((double)this.totalMembers().longValue() / (double)this.pageSize);
    }

    public Long totalMembersInScoreRange(double minScore, double maxScore) {
        String minScoreStr = LeaderBoard.joinScoresToString(minScore);
        String maxScoreStr = LeaderBoard.joinScoresToString(maxScore);
        return this.totalMembersInScoreRange(minScoreStr, maxScoreStr);
    }

    public Long totalMembersInScoreRange(String minScore, String maxScore) {
        long counts = 0L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZCOUNT, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i)), SafeEncoder.encode((String)minScore), SafeEncoder.encode((String)maxScore)});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                counts += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        return counts;
    }

    public Long removeMembersInScoreRange(double minScore, double maxScore) {
        String minScoreStr = LeaderBoard.joinScoresToString(minScore);
        String maxScoreStr = LeaderBoard.joinScoresToString(maxScore);
        return this.removeMembersInScoreRange(minScoreStr, maxScoreStr);
    }

    public Long removeMembersInScoreRange(String minScore, String maxScore) {
        long counts = 0L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i)), SafeEncoder.encode((String)minScore), SafeEncoder.encode((String)maxScore)});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                counts += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        return counts;
    }

    public String scoreFor(String member) {
        return this.scoreFor(SafeEncoder.encode((String)member));
    }

    public String scoreFor(byte[] member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZSCORE, (byte[][])new byte[][]{SafeEncoder.encode((String)this.crcKeyByMember(member)), member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
    }

    public Long rankFor(String member) {
        return this.rankFor(SafeEncoder.encode((String)member), new RankParams());
    }

    public Long rankFor(byte[] member) {
        return this.rankFor(member, new RankParams());
    }

    public Long rankFor(String member, RankParams rankParams) {
        return this.rankFor(SafeEncoder.encode((String)member), rankParams);
    }

    public Long rankFor(byte[] member, RankParams rankParams) {
        long rank = 0L;
        String score = this.scoreFor(member);
        if (score == null) {
            return -1L;
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                if (this.reverse) {
                    p.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE, rankParams.getByteParams(SafeEncoder.encode((String)this.joinKeyAndIndex(i)), SafeEncoder.encode((String)score)));
                    continue;
                }
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZRANKBYSCORE, rankParams.getByteParams(SafeEncoder.encode((String)this.joinKeyAndIndex(i)), SafeEncoder.encode((String)score)));
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                if (objs.get(i) == null) {
                    LOGGER.error("Could not find key: {}", (Object)SafeEncoder.encode((String)this.joinKeyAndIndex(i)));
                    continue;
                }
                rank += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        if (!this.useZeroIndexForRank) {
            ++rank;
        }
        if (this.reverse) {
            --rank;
        }
        return rank;
    }

    public LeaderData scoreAndRankFor(String member) {
        return this.scoreAndRankFor(SafeEncoder.encode((String)member));
    }

    public LeaderData scoreAndRankFor(byte[] member) {
        String score = this.scoreFor(member);
        Long rank = this.rankFor(member);
        return new LeaderData(new String(member), score, rank);
    }

    public List<LeaderData> top(long number) {
        ArrayList<LeaderData> leaderDataList = new ArrayList<LeaderData>();
        if (number < 1L) {
            number = 1L;
        }
        long totalMembers = this.totalMembers();
        long startRank = 0L;
        long endRank = number > totalMembers ? totalMembers - 1L : number - 1L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                if (this.reverse) {
                    p.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i)), Protocol.toByteArray((long)startRank), Protocol.toByteArray((long)endRank), SafeEncoder.encode((String)WITHSCORES)});
                    continue;
                }
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i)), Protocol.toByteArray((long)startRank), Protocol.toByteArray((long)endRank), SafeEncoder.encode((String)WITHSCORES)});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                if (objs.get(i) == null) {
                    LOGGER.error("Could not find key: {}", (Object)SafeEncoder.encode((String)this.joinKeyAndIndex(i)));
                    continue;
                }
                List rangeRets = (List)BuilderFactory.STRING_LIST.build(objs.get(i));
                if (rangeRets == null) continue;
                for (int j = 0; j < rangeRets.size(); j += 2) {
                    String member = (String)rangeRets.get(j);
                    String score = (String)rangeRets.get(j + 1);
                    Long rank = null;
                    if (this.queryRankFromRedis) {
                        rank = this.rankFor(member);
                    }
                    leaderDataList.add(new LeaderData(member, score, rank));
                }
            }
        }
        if (this.reverse) {
            leaderDataList.sort(Collections.reverseOrder());
        } else {
            Collections.sort(leaderDataList);
        }
        if (this.queryRankFromRedis) {
            return leaderDataList.subList(0, (int)endRank + 1);
        }
        List<LeaderData> leaderDatas = leaderDataList.subList(0, (int)endRank + 1);
        long rank = this.useZeroIndexForRank ? 0L : 1L;
        for (LeaderData data : leaderDatas) {
            data.setRank(rank++);
        }
        return leaderDatas;
    }

    public List<LeaderData> leaders(long page) {
        long startOffset;
        long endOffset;
        long totalMembers;
        long totalPages;
        if (page < 1L) {
            page = 1L;
        }
        if (page > (totalPages = (long)Math.ceil((double)(totalMembers = this.totalMembers().longValue()) / (double)this.pageSize))) {
            page = totalPages;
        }
        if ((endOffset = (startOffset = (page - 1L) * (long)this.pageSize) + (long)this.pageSize) > totalMembers) {
            endOffset = totalMembers;
        }
        List<LeaderData> leaderDataList = this.top(endOffset);
        return leaderDataList.subList((int)startOffset, (int)endOffset);
    }

    public Long expireLeaderBoard(long seconds) {
        long expires = 0L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                p.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i)), Protocol.toByteArray((long)seconds)});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                expires += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        return expires;
    }

    public Long delLeaderBoard() {
        long dels = 0L;
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (int i = 0; i < this.shardKeySize; ++i) {
                p.sendCommand((ProtocolCommand)Protocol.Command.DEL, (byte[][])new byte[][]{SafeEncoder.encode((String)this.joinKeyAndIndex(i))});
            }
            List objs = p.syncAndReturnAll();
            for (int i = 0; i < objs.size(); ++i) {
                dels += ((Long)BuilderFactory.LONG.build(objs.get(i))).longValue();
            }
        }
        return dels;
    }
}

