/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairzset;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.tairzset.LeaderData;
import com.aliyun.tair.tairzset.params.RankParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class LeaderBoard {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderBoard.class);
    private static final String CH = "CH";
    private static final String WITHSCORES = "WITHSCORES";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final boolean DEFAULT_REVERSE = false;
    private static final boolean DEFAULT_USE_ZERO_INDEX = true;
    public static final boolean DEFAULT_QUERY_RANK_FROM_REDIS = false;
    private final String name;
    private final byte[] nameBinary;
    private final JedisPool jedisPool;
    private final int pageSize;
    private final boolean reverse;
    private final boolean useZeroIndexForRank;
    private final boolean queryRankFromRedis;

    public LeaderBoard(String name, JedisPool jedisPool) {
        this(name, jedisPool, 10);
    }

    public LeaderBoard(String name, JedisPool jedisPool, int pageSize) {
        this(name, jedisPool, pageSize, false);
    }

    public LeaderBoard(String name, JedisPool jedisPool, int pageSize, boolean reverse) {
        this(name, jedisPool, pageSize, reverse, true);
    }

    public LeaderBoard(String name, JedisPool jedisPool, int pageSize, boolean reverse, boolean useZeroIndexForRank) {
        this(name, jedisPool, pageSize, reverse, useZeroIndexForRank, false);
    }

    public LeaderBoard(String name, JedisPool jedisPool, int pageSize, boolean reverse, boolean useZeroIndexForRank, boolean queryRankFromRedis) {
        this.name = name;
        this.nameBinary = SafeEncoder.encode((String)name);
        this.jedisPool = jedisPool;
        this.pageSize = pageSize;
        this.reverse = reverse;
        this.useZeroIndexForRank = useZeroIndexForRank;
        this.queryRankFromRedis = queryRankFromRedis;
    }

    public static String joinScoresToString(double ... scores) {
        StringBuilder mscore = new StringBuilder();
        for (double score : scores) {
            mscore.append(score);
            mscore.append("#");
        }
        return mscore.substring(0, mscore.length() - 1);
    }

    public Boolean addMember(String member, String scores) {
        return this.addMember(SafeEncoder.encode((String)member), SafeEncoder.encode((String)scores));
    }

    public Boolean addMember(String member, double ... scores) {
        return this.addMember(SafeEncoder.encode((String)member), SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)));
    }

    public Boolean addMember(byte[] member, double ... scores) {
        return this.addMember(member, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)));
    }

    public Boolean addMember(byte[] member, byte[] score) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{this.nameBinary, SafeEncoder.encode((String)CH), score, member});
            Boolean bl = (Boolean)BuilderFactory.BOOLEAN.build(obj);
            return bl;
        }
    }

    public List<Boolean> addMember(Map<String, String> memberScores) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        try (Jedis jedis = this.jedisPool.getResource();){
            Pipeline p = jedis.pipelined();
            for (Map.Entry<String, String> entry : memberScores.entrySet()) {
                p.sendCommand((ProtocolCommand)ModuleCommand.EXZADD, (byte[][])new byte[][]{this.nameBinary, SafeEncoder.encode((String)CH), SafeEncoder.encode((String)entry.getValue()), SafeEncoder.encode((String)entry.getKey())});
            }
            List objs = p.syncAndReturnAll();
            for (Object obj : objs) {
                results.add((Boolean)BuilderFactory.BOOLEAN.build(obj));
            }
        }
        return results;
    }

    public String incrScoreFor(String member, String increment) {
        return this.incrScoreFor(SafeEncoder.encode((String)member), increment);
    }

    public String incrScoreFor(byte[] member, String increment) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZINCRBY, (byte[][])new byte[][]{this.nameBinary, SafeEncoder.encode((String)increment), member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
    }

    public Long removeMember(String ... members) {
        return this.removeMember(SafeEncoder.encodeMany((String[])members));
    }

    public Long removeMember(byte[] ... members) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREM, JoinParameters.joinParameters(this.nameBinary, members));
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public List<LeaderData> retrieveMember(long startOffset, long endOffset) {
        ArrayList<LeaderData> leaderDataList = new ArrayList<LeaderData>();
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = this.reverse ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANGE, (byte[][])new byte[][]{this.nameBinary, Protocol.toByteArray((long)startOffset), Protocol.toByteArray((long)endOffset), SafeEncoder.encode((String)WITHSCORES)}) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANGE, (byte[][])new byte[][]{this.nameBinary, Protocol.toByteArray((long)startOffset), Protocol.toByteArray((long)endOffset), SafeEncoder.encode((String)WITHSCORES)});
            long rank = this.useZeroIndexForRank ? startOffset - 1L : startOffset;
            List rangeRets = (List)BuilderFactory.STRING_LIST.build(obj);
            if (rangeRets != null) {
                for (int i = 0; i < rangeRets.size(); i += 2) {
                    String member = (String)rangeRets.get(i);
                    String score = (String)rangeRets.get(i + 1);
                    rank = this.queryRankFromRedis ? this.rankFor(member) : ++rank;
                    leaderDataList.add(new LeaderData(member, score, rank));
                }
            }
        }
        return leaderDataList;
    }

    public Long totalMembers() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCARD, (byte[][])new byte[][]{this.nameBinary});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public Long totalPages() {
        return (long)Math.ceil((double)this.totalMembers().longValue() / (double)this.pageSize);
    }

    public Long totalMembersInScoreRange(double minScore, double maxScore) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCOUNT, (byte[][])new byte[][]{this.nameBinary, Protocol.toByteArray((double)minScore), Protocol.toByteArray((double)maxScore)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public Long totalMembersInScoreRange(String minScore, String maxScore) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZCOUNT, (byte[][])new byte[][]{this.nameBinary, SafeEncoder.encode((String)minScore), SafeEncoder.encode((String)maxScore)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public Long removeMembersInScoreRange(double minScore, double maxScore) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, (byte[][])new byte[][]{this.nameBinary, Protocol.toByteArray((double)minScore), Protocol.toByteArray((double)maxScore)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public Long removeMembersInScoreRange(String minScore, String maxScore) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE, (byte[][])new byte[][]{this.nameBinary, SafeEncoder.encode((String)minScore), SafeEncoder.encode((String)maxScore)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public String scoreFor(String member) {
        return this.scoreFor(SafeEncoder.encode((String)member));
    }

    public String scoreFor(byte[] member) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZSCORE, (byte[][])new byte[][]{this.nameBinary, member});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
    }

    public Long rankFor(String member) {
        return this.rankFor(SafeEncoder.encode((String)member), new RankParams());
    }

    public Long rankFor(byte[] member) {
        return this.rankFor(member, new RankParams());
    }

    public Long rankFor(String member, RankParams rankParams) {
        return this.rankFor(SafeEncoder.encode((String)member), rankParams);
    }

    public Long rankFor(byte[] member, RankParams rankParams) {
        Object obj;
        try (Jedis jedis = this.jedisPool.getResource();){
            obj = this.reverse ? jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZREVRANK, rankParams.getByteParams(this.nameBinary, member)) : jedis.sendCommand((ProtocolCommand)ModuleCommand.EXZRANK, rankParams.getByteParams(this.nameBinary, member));
        }
        Long rank = (Long)BuilderFactory.LONG.build(obj);
        if (rank != null && !this.useZeroIndexForRank) {
            rank = rank + 1L;
        }
        return rank;
    }

    public LeaderData scoreAndRankFor(String member) {
        return this.scoreAndRankFor(SafeEncoder.encode((String)member));
    }

    public LeaderData scoreAndRankFor(byte[] member) {
        String score = this.scoreFor(member);
        Long rank = this.rankFor(member);
        return new LeaderData(new String(member), score, rank);
    }

    public List<LeaderData> top(long number) {
        if (number < 1L) {
            number = 1L;
        }
        long totalMembers = this.totalMembers();
        long startRank = 0L;
        long endRank = number > totalMembers ? totalMembers - 1L : number - 1L;
        return this.retrieveMember(startRank, endRank);
    }

    public List<LeaderData> leaders(long page) {
        long startOffset;
        long endOffset;
        long totalMembers;
        long totalPages;
        if (page < 1L) {
            page = 1L;
        }
        if (page > (totalPages = (long)Math.ceil((double)(totalMembers = this.totalMembers().longValue()) / (double)this.pageSize))) {
            page = totalPages;
        }
        if ((endOffset = (startOffset = (page - 1L) * (long)this.pageSize) + (long)this.pageSize - 1L) > totalMembers) {
            endOffset = totalMembers - 1L;
        }
        return this.retrieveMember(startOffset, endOffset);
    }

    public List<LeaderData> allLeaders() {
        long startOffset = 0L;
        long endOffset = -1L;
        return this.retrieveMember(startOffset, endOffset);
    }

    public Long expireLeaderBoard(long seconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)Protocol.Command.EXPIRE, (byte[][])new byte[][]{this.nameBinary, Protocol.toByteArray((long)seconds)});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }

    public Long delLeaderBoard() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object obj = jedis.sendCommand((ProtocolCommand)Protocol.Command.DEL, (byte[][])new byte[][]{this.nameBinary});
            Long l = (Long)BuilderFactory.LONG.build(obj);
            return l;
        }
    }
}

