/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairzset;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairzset.LeaderBoard;
import com.aliyun.tair.tairzset.params.ExzaddParams;
import com.aliyun.tair.tairzset.params.ExzrangeParams;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairZsetPipeline
extends Pipeline {
    public TairZsetPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<Long> exzadd(String key, String member, double ... scores) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), SafeEncoder.encode((String)member));
    }

    public Response<Long> exzadd(byte[] key, byte[] member, double ... scores) {
        return this.exzadd(key, SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores)), member);
    }

    public Response<Long> exzadd(String key, String score, String member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).add(key).add(score).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzadd(byte[] key, byte[] score, byte[] member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).add(key).add(score).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzadd(String key, String score, String member, ExzaddParams params) {
        return this.exzadd(SafeEncoder.encode((String)key), SafeEncoder.encode((String)score), SafeEncoder.encode((String)member), params);
    }

    public Response<Long> exzadd(byte[] key, byte[] score, byte[] member, ExzaddParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects((Object[])params.getByteParams(key, score, member)), BuilderFactory.LONG));
    }

    @Deprecated
    public Response<Long> exzadd(String key, Map<String, String> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects(bparams), BuilderFactory.LONG));
    }

    public Response<Long> exzaddMembers(String key, Map<String, String> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(SafeEncoder.encode((String)key));
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects(bparams), BuilderFactory.LONG));
    }

    @Deprecated
    public Response<Long> exzadd(byte[] key, Map<byte[], byte[]> scoreMembers) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects(bparams), BuilderFactory.LONG));
    }

    public Response<Long> exzaddMembers(byte[] key, Map<byte[], byte[]> members) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        bparams.add(key);
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects(bparams), BuilderFactory.LONG));
    }

    @Deprecated
    public Response<Long> exzadd(String key, Map<String, String> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : scoreMembers.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][]))), BuilderFactory.LONG));
    }

    public Response<Long> exzaddMembers(String key, Map<String, String> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<String, String> entry : members.entrySet()) {
            bparams.add(SafeEncoder.encode((String)entry.getValue()));
            bparams.add(SafeEncoder.encode((String)entry.getKey()));
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), (byte[][])bparams.toArray((T[])new byte[bparams.size()][]))), BuilderFactory.LONG));
    }

    @Deprecated
    public Response<Long> exzadd(byte[] key, Map<byte[], byte[]> scoreMembers, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : scoreMembers.entrySet()) {
            bparams.add(entry.getKey());
            bparams.add(entry.getValue());
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects((Object[])params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]))), BuilderFactory.LONG));
    }

    public Response<Long> exzaddMembers(byte[] key, Map<byte[], byte[]> members, ExzaddParams params) {
        ArrayList<byte[]> bparams = new ArrayList<byte[]>();
        for (Map.Entry<byte[], byte[]> entry : members.entrySet()) {
            bparams.add(entry.getValue());
            bparams.add(entry.getKey());
        }
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZADD).addObjects((Object[])params.getByteParams(key, (byte[][])bparams.toArray((T[])new byte[bparams.size()][]))), BuilderFactory.LONG));
    }

    public Response<String> exzincrBy(String key, String increment, String member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZINCRBY).add(key).add(increment).add(member), BuilderFactory.STRING));
    }

    public Response<byte[]> exzincrBy(byte[] key, byte[] increment, byte[] member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZINCRBY).add(key).add(increment).add(member), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<String> exzincrBy(String key, String member, double ... scores) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZINCRBY).add(key).add(LeaderBoard.joinScoresToString(scores)).add(member), BuilderFactory.STRING));
    }

    public Response<byte[]> exzincrBy(byte[] key, byte[] member, double ... scores) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZINCRBY).add(key).add(SafeEncoder.encode((String)LeaderBoard.joinScoresToString(scores))).add(member), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<Long> exzrem(String key, String ... member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREM).addObjects((Object[])JoinParameters.joinParameters(key, member)), BuilderFactory.LONG));
    }

    public Response<Long> exzrem(byte[] key, byte[] ... member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREM).addObjects((Object[])JoinParameters.joinParameters(key, member)), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByScore(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYSCORE).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByRank(String key, long start, long stop) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYRANK).add(key).add(Protocol.toByteArray((long)start)).add(Protocol.toByteArray((long)stop)), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByRank(byte[] key, long start, long stop) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYRANK).add(key).add(Protocol.toByteArray((long)start)).add(Protocol.toByteArray((long)stop)), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByLex(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzremrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREMRANGEBYLEX).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<String> exzscore(String key, String member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZSCORE).add(key).add(member), BuilderFactory.STRING));
    }

    public Response<byte[]> exzscore(byte[] key, byte[] member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZSCORE).add(key).add(member), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<List<String>> exzrange(String key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrange(byte[] key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGE).add(key).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrangeWithScores(String key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)).add(SafeEncoder.encode((String)"WITHSCORES")), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrangeWithScores(byte[] key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGE).add(key).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)).add(SafeEncoder.encode((String)"WITHSCORES")), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrange(String key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrange(byte[] key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGE).add(key).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrangeWithScores(String key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGE).add(SafeEncoder.encode((String)key)).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)).add(SafeEncoder.encode((String)"WITHSCORES")), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrangeWithScores(byte[] key, long min, long max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGE).add(key).add(Protocol.toByteArray((long)min)).add(Protocol.toByteArray((long)max)).add(SafeEncoder.encode((String)"WITHSCORES")), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrangeByScore(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE).add(key).add(min).add(max), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE).add(key).add(min).add(max), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrangeByScore(String key, String min, String max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max))), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYSCORE).addObjects((Object[])params.getByteParams(key, min, max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrangeByScore(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE).add(key).add(min).add(max), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE).add(key).add(min).add(max), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrangeByScore(String key, String min, String max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max))), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrangeByScore(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYSCORE).addObjects((Object[])params.getByteParams(key, min, max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrangeByLex(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX).add(key).add(min).add(max), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX).add(key).add(min).add(max), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrangeByLex(String key, String min, String max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max))), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANGEBYLEX).addObjects((Object[])params.getByteParams(key, min, max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrangeByLex(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX).add(key).add(min).add(max), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX).add(key).add(min).add(max), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<List<String>> exzrevrangeByLex(String key, String min, String max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX).addObjects((Object[])params.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)min), SafeEncoder.encode((String)max))), BuilderFactory.STRING_LIST));
    }

    public Response<List<byte[]>> exzrevrangeByLex(byte[] key, byte[] min, byte[] max, ExzrangeParams params) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANGEBYLEX).addObjects((Object[])params.getByteParams(key, min, max)), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }

    public Response<Long> exzcard(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZCARD).add(key), BuilderFactory.LONG));
    }

    public Response<Long> exzcard(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZCARD).add(key), BuilderFactory.LONG));
    }

    public Response<Long> exzrank(String key, String member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANK).add(key).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzrank(byte[] key, byte[] member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANK).add(key).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzrevrank(String key, String member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANK).add(key).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzrevrank(byte[] key, byte[] member) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANK).add(key).add(member), BuilderFactory.LONG));
    }

    public Response<Long> exzrankByScore(String key, String score) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANKBYSCORE).add(key).add(score), BuilderFactory.LONG));
    }

    public Response<Long> exzrankByScore(byte[] key, byte[] score) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZRANKBYSCORE).add(key).add(score), BuilderFactory.LONG));
    }

    public Response<Long> exzrevrankByScore(String key, String score) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE).add(key).add(score), BuilderFactory.LONG));
    }

    public Response<Long> exzrevrankByScore(byte[] key, byte[] score) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZREVRANKBYSCORE).add(key).add(score), BuilderFactory.LONG));
    }

    public Response<Long> exzcount(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZCOUNT).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzcount(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZCOUNT).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzlexcount(String key, String min, String max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZLEXCOUNT).add(key).add(min).add(max), BuilderFactory.LONG));
    }

    public Response<Long> exzlexcount(byte[] key, byte[] min, byte[] max) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.EXZLEXCOUNT).add(key).add(min).add(max), BuilderFactory.LONG));
    }
}

