/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import com.alkacon.diff.BlockComparator;
import com.alkacon.diff.DiffLineType;
import com.alkacon.diff.HtmlDiffOutput;
import com.alkacon.diff.I_DiffConfiguration;
import com.alkacon.diff.I_DiffOutput;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import com.alkacon.diff.I_TextDiffConfiguration;
import com.alkacon.diff.TextComparator;
import com.alkacon.diff.TextDiffOutput;
import com.alkacon.diff.XmlSaxWriter;
import com.alkacon.diff.rangedifferencer.RangeDifference;
import com.alkacon.diff.rangedifferencer.RangeDifferencer;
import java.io.StringWriter;
import java.io.Writer;

public final class Diff {
    private static final int MIN_EQUAL_LINES = 3;

    private Diff() {
    }

    public static void diff(String text1, String text2, I_DiffOutput output, I_DiffConfiguration config) throws Exception {
        TextComparator leftComparator = new TextComparator(text1);
        TextComparator rightComparator = new TextComparator(text2);
        RangeDifference[] differences = RangeDifferencer.findDifferences(leftComparator, rightComparator);
        int pos = 0;
        if (differences.length > 0) {
            int diffIndex = 0;
            int leftLineCount = leftComparator.getRangeCount();
            do {
                RangeDifference diff;
                if ((diff = differences[diffIndex]).kind() == 2) {
                    int currentLine;
                    int i;
                    int endContextStartPos;
                    int nextChangedLine = diff.leftStart();
                    if (pos != 0) {
                        int beginContextEndPos = pos + config.getLinesBeforeSkip();
                        while ((pos < beginContextEndPos || config.getLinesBeforeSkip() == -1) && pos + 3 < nextChangedLine) {
                            output.startLine(DiffLineType.UNCHANGED);
                            output.addUnchangedText(leftComparator.getLine(pos));
                            output.endLine();
                            ++pos;
                        }
                    }
                    if (config.getLinesBeforeSkip() >= 0 && (endContextStartPos = nextChangedLine - config.getLinesBeforeSkip()) >= pos + 3) {
                        output.skippedLines(endContextStartPos - pos);
                        pos = endContextStartPos;
                    }
                    while (pos < nextChangedLine) {
                        output.startLine(DiffLineType.UNCHANGED);
                        output.addUnchangedText(leftComparator.getLine(pos));
                        output.endLine();
                        ++pos;
                    }
                    StringBuffer leftBlock = null;
                    StringBuffer rightBlock = null;
                    if (diff.leftLength() > 0 && diff.rightLength() > 0) {
                        leftBlock = Diff.concatLines(leftComparator, diff.leftStart(), diff.leftLength());
                        rightBlock = Diff.concatLines(rightComparator, diff.rightStart(), diff.rightLength());
                    }
                    if (leftBlock == null) {
                        for (i = 0; i < diff.leftLength(); ++i) {
                            currentLine = diff.leftStart() + i;
                            output.startLine(DiffLineType.REMOVED);
                            output.addUnchangedText(leftComparator.getLine(currentLine));
                            output.endLine();
                        }
                    } else {
                        Diff.diffBlock(leftBlock, rightBlock, output, DiffLineType.REMOVED);
                    }
                    if (leftBlock == null) {
                        for (i = 0; i < diff.rightLength(); ++i) {
                            currentLine = diff.rightStart() + i;
                            output.startLine(DiffLineType.ADDED);
                            output.addUnchangedText(rightComparator.getLine(currentLine));
                            output.endLine();
                        }
                    } else {
                        Diff.diffBlock(rightBlock, leftBlock, output, DiffLineType.ADDED);
                    }
                }
                pos = differences[diffIndex].leftEnd();
            } while (++diffIndex < differences.length && pos < leftLineCount);
            int endPos = pos;
            int beginContextEndPos = endPos + config.getLinesBeforeSkip();
            while ((pos < beginContextEndPos || config.getLinesBeforeSkip() == -1) && pos + 3 < leftLineCount + config.getLinesBeforeSkip()) {
                output.startLine(DiffLineType.UNCHANGED);
                output.addUnchangedText(leftComparator.getLine(pos));
                output.endLine();
                ++pos;
            }
            int endContextStartPos = leftLineCount;
            if (config.getLinesBeforeSkip() >= 0 && endContextStartPos >= pos + 3) {
                output.skippedLines(endContextStartPos - pos);
                pos = endContextStartPos;
            } else {
                while (pos < leftLineCount) {
                    output.startLine(DiffLineType.UNCHANGED);
                    output.addUnchangedText(leftComparator.getLine(pos));
                    output.endLine();
                    ++pos;
                }
            }
        }
    }

    public static String diffAsHtml(String text1, String text2, I_HtmlDiffConfiguration config) throws Exception {
        StringWriter writer = new StringWriter(4096);
        Diff.diffAsHtml(text1, text2, writer, config);
        return writer.toString();
    }

    public static void diffAsHtml(String text1, String text2, Writer writer, I_HtmlDiffConfiguration config) throws Exception {
        XmlSaxWriter saxWriter = new XmlSaxWriter(writer);
        HtmlDiffOutput output = new HtmlDiffOutput(saxWriter, config);
        Diff.diff(text1, text2, output, config);
    }

    public static String diffAsText(String text1, String text2, I_TextDiffConfiguration config) throws Exception {
        StringWriter writer = new StringWriter(4096);
        Diff.diffAsText(text1, text2, writer, config);
        return writer.toString();
    }

    public static void diffAsText(String text1, String text2, Writer writer, I_TextDiffConfiguration config) throws Exception {
        TextDiffOutput output = new TextDiffOutput(writer, config);
        Diff.diff(text1, text2, output, config);
    }

    private static StringBuffer concatLines(TextComparator comparator, int start, int count) {
        int totalLinesLength = 0;
        for (int i = 0; i < count; ++i) {
            totalLinesLength += comparator.getLine(start + i).length() + 1;
        }
        StringBuffer result = new StringBuffer(totalLinesLength);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                result.append("\n");
            }
            result.append(comparator.getLine(start + i));
        }
        return result;
    }

    private static void diffBlock(StringBuffer block1, StringBuffer block2, I_DiffOutput output, DiffLineType diffLineType) throws Exception {
        BlockComparator leftBlockComparator = new BlockComparator(block1);
        BlockComparator rightBlockComparator = new BlockComparator(block2);
        RangeDifference[] lineDiffs = RangeDifferencer.findDifferences(leftBlockComparator, rightBlockComparator);
        int pos = 0;
        RangeDifference diff = null;
        output.startLine(diffLineType);
        for (int i = 0; i < lineDiffs.length; ++i) {
            int d;
            String[] strings;
            diff = lineDiffs[i];
            int left = diff.leftStart();
            if (pos < left) {
                strings = leftBlockComparator.substringSplitted(pos, left);
                for (d = 0; d < strings.length; ++d) {
                    if (strings[d].equals("\n")) {
                        output.endLine();
                        output.startLine(diffLineType);
                        continue;
                    }
                    output.addUnchangedText(strings[d]);
                }
            }
            if (diff.leftLength() > 0) {
                strings = leftBlockComparator.substringSplitted(left, diff.leftEnd());
                for (d = 0; d < strings.length; ++d) {
                    if (strings[d].equals("\n")) {
                        output.endLine();
                        output.startLine(diffLineType);
                        continue;
                    }
                    output.addChangedText(strings[d]);
                }
            }
            pos = diff.leftEnd();
        }
        if (diff == null || diff.leftEnd() < leftBlockComparator.getRangeCount()) {
            int start = 0;
            if (diff != null) {
                start = diff.leftEnd();
            }
            String[] strings = leftBlockComparator.substringSplitted(start);
            for (int d = 0; d < strings.length; ++d) {
                if (strings[d].equals("\n")) {
                    output.endLine();
                    output.startLine(diffLineType);
                    continue;
                }
                output.addUnchangedText(strings[d]);
            }
            output.endLine();
        } else {
            output.endLine();
        }
    }
}

