/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import com.alkacon.diff.DiffLineType;
import com.alkacon.diff.I_DiffOutput;
import com.alkacon.diff.I_HtmlDiffConfiguration;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlDiffOutput
implements I_DiffOutput {
    private ContentHandler m_handler;
    private DiffLineType m_currentLineType;
    private I_HtmlDiffConfiguration m_config;

    public HtmlDiffOutput(ContentHandler handler, I_HtmlDiffConfiguration config) {
        this.m_handler = handler;
        this.m_config = config;
    }

    public void addChangedText(String text) throws Exception {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "class", "class", "CDATA", this.m_config.getSpanStyleName(this.m_currentLineType));
        this.m_handler.startElement("", "span", "span", attrs);
        this.m_handler.characters(text.toCharArray(), 0, text.length());
        this.m_handler.endElement("", "span", "span");
    }

    public void addUnchangedText(String text) throws Exception {
        if (this.m_config.getSpanStyleName(DiffLineType.UNCHANGED) != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "class", "class", "CDATA", this.m_config.getSpanStyleName(DiffLineType.UNCHANGED));
            this.m_handler.startElement("", "span", "span", attrs);
            if (text == null || text.length() == 0) {
                text = " ";
            }
            this.m_handler.characters(text.toCharArray(), 0, text.length());
            this.m_handler.endElement("", "span", "span");
        } else {
            this.m_handler.characters(text.toCharArray(), 0, text.length());
        }
    }

    public void endLine() throws Exception {
        this.m_handler.endElement("", "div", "div");
    }

    public void skippedLines(int linesSkipped) throws Exception {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "class", "class", "CDATA", this.m_config.getDivStyleName(DiffLineType.SKIPPED));
        String nbsp = " ";
        this.m_handler.startElement("", "div", "div", attrs);
        this.m_handler.characters(nbsp.toCharArray(), 0, nbsp.length());
        this.m_handler.endElement("", "div", "div");
        this.m_handler.startElement("", "div", "div", attrs);
        String message = this.m_config.getMessageEqualLinesSkipped(linesSkipped);
        this.m_handler.characters(message.toCharArray(), 0, message.length());
        this.m_handler.endElement("", "div", "div");
        this.m_handler.startElement("", "div", "div", attrs);
        this.m_handler.characters(nbsp.toCharArray(), 0, nbsp.length());
        this.m_handler.endElement("", "div", "div");
    }

    public void startLine(DiffLineType type) throws Exception {
        this.m_currentLineType = type;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "class", "class", "CDATA", this.m_config.getDivStyleName(type));
        this.m_handler.startElement("", "div", "div", attrs);
    }
}

