/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSaxWriter
extends DefaultHandler
implements LexicalHandler {
    private static final String INDENT_STR = "\t";
    private boolean m_escapeXml;
    private int m_indentLevel;
    private boolean m_indentXml;
    private boolean m_isCdata;
    private String m_lastElementName;
    private boolean m_openCdata;
    private boolean m_openElement;
    private Writer m_writer;

    public XmlSaxWriter(Writer writer) {
        this.m_writer = writer;
        this.m_indentLevel = 0;
        this.m_escapeXml = true;
        this.m_indentXml = false;
    }

    public static String escapeXml(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(source.length() * 2);
        block7: for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\t': {
                    result.append("    ");
                    continue block7;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return new String(result);
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (len == 0) {
            return;
        }
        if (this.m_openElement) {
            this.write(">");
            this.m_openElement = false;
        }
        if (this.m_openCdata) {
            this.write("<![CDATA[");
            this.m_openCdata = false;
        }
        if (this.m_escapeXml && !this.m_isCdata) {
            String escaped = new String(buf, offset, len);
            escaped = XmlSaxWriter.escapeXml(escaped);
            this.write(escaped);
        } else {
            this.write(new String(buf, offset, len));
        }
    }

    public void comment(char[] ch, int start, int length) {
    }

    public void endCDATA() throws SAXException {
        if (!this.m_openCdata) {
            this.write("]]>");
        }
        this.m_openCdata = false;
        this.m_isCdata = false;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.m_openElement) {
                this.closeLastOpenElement(this.m_lastElementName);
            }
            this.writeNewLine();
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endDTD() {
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        String elementName = this.resolveName(localName, qualifiedName);
        this.closeLastOpenElement(elementName);
    }

    public void endEntity(String name) {
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public boolean isEscapeXml() {
        return this.m_escapeXml;
    }

    public boolean isIndentXml() {
        return this.m_indentXml;
    }

    public void setEscapeXml(boolean value) {
        this.m_escapeXml = value;
    }

    public void setIndentXml(boolean value) {
        this.m_indentXml = value;
    }

    public void startCDATA() {
        this.m_openCdata = true;
        this.m_isCdata = true;
    }

    public void startDocument() throws SAXException {
        this.write("<?xml version=\"1.0\" encoding=\"");
        this.write("UTF-8");
        this.write("\"?>");
        this.writeNewLine();
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.m_openElement) {
            this.write(">");
            this.m_openElement = false;
        }
        ++this.m_indentLevel;
        this.writeNewLine();
        this.m_lastElementName = this.resolveName(localName, qualifiedName);
        this.write("<");
        this.write(this.m_lastElementName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.write(" ");
                this.write(this.resolveName(attributes.getLocalName(i), attributes.getQName(i)));
                this.write("=\"");
                this.write(attributes.getValue(i));
                this.write("\"");
            }
        }
        this.m_openElement = true;
    }

    public void startEntity(String name) {
    }

    private void closeLastOpenElement(String elementName) throws SAXException {
        if (this.m_openElement) {
            this.write("></");
        } else {
            if (!elementName.equals(this.m_lastElementName)) {
                this.writeNewLine();
            }
            this.write("</");
        }
        this.write(elementName);
        this.write(">");
        --this.m_indentLevel;
        if (!this.m_indentXml) {
            this.writeNewLine();
        }
        this.m_openElement = false;
    }

    private String resolveName(String localName, String qualifiedName) {
        if (localName == null || localName.length() == 0) {
            return qualifiedName;
        }
        return localName;
    }

    private void write(String s) throws SAXException {
        try {
            this.m_writer.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    private void writeNewLine() throws SAXException {
        try {
            if (this.m_indentXml || this.m_indentLevel == 0) {
                this.m_writer.write("\r\n");
                for (int i = 1; i < this.m_indentLevel; ++i) {
                    this.m_writer.write(INDENT_STR);
                }
            }
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }
}

