/*
 * Decompiled with CFR 0.152.
 */
package com.alkacon.diff.rangedifferencer;

import com.alkacon.diff.rangedifferencer.DifferencesIterator;
import com.alkacon.diff.rangedifferencer.I_RangeComparator;
import com.alkacon.diff.rangedifferencer.LinkedRangeDifference;
import com.alkacon.diff.rangedifferencer.RangeDifference;
import java.util.ArrayList;
import java.util.List;

public final class RangeDifferencer {
    private static final RangeDifference[] EMPTY_RESULT = new RangeDifference[0];

    private RangeDifferencer() {
    }

    public static boolean assertIsTrue(boolean expression) {
        if (expression) {
            return true;
        }
        throw new RuntimeException("Assertion in diff code failed");
    }

    public static RangeDifference[] findDifferences(I_RangeComparator left, I_RangeComparator right) {
        int upper;
        int row;
        int diagLen;
        RangeDifferencer.assertIsTrue(right.getClass().equals(left.getClass()));
        int rightSize = right.getRangeCount();
        int leftSize = left.getRangeCount();
        int maxDiagonal = diagLen = 2 * Math.max(rightSize, leftSize);
        int[] lastDiagonal = new int[diagLen + 1];
        int origin = diagLen / 2;
        LinkedRangeDifference[] script = new LinkedRangeDifference[diagLen + 1];
        for (row = 0; row < rightSize && row < leftSize && RangeDifferencer.rangesEqual(right, row, left, row); ++row) {
        }
        lastDiagonal[origin] = row;
        script[origin] = null;
        int lower = row == rightSize ? origin + 1 : origin - 1;
        int n = upper = row == leftSize ? origin - 1 : origin + 1;
        if (lower > upper) {
            return EMPTY_RESULT;
        }
        for (int d = 1; d <= maxDiagonal; ++d) {
            if (right.skipRangeComparison(d, maxDiagonal, left)) {
                return EMPTY_RESULT;
            }
            for (int k = lower; k <= upper; k += 2) {
                int col;
                LinkedRangeDifference edit;
                if (k == origin - d || k != origin + d && lastDiagonal[k + 1] >= lastDiagonal[k - 1]) {
                    row = lastDiagonal[k + 1] + 1;
                    edit = new LinkedRangeDifference(script[k + 1], 1);
                } else {
                    row = lastDiagonal[k - 1];
                    edit = new LinkedRangeDifference(script[k - 1], 0);
                }
                edit.m_fRightStart = row;
                edit.m_fLeftStart = col;
                RangeDifferencer.assertIsTrue(k >= 0 && k <= maxDiagonal);
                script[k] = edit;
                for (col = row + k - origin; row < rightSize && col < leftSize && RangeDifferencer.rangesEqual(right, row, left, col); ++row, ++col) {
                }
                RangeDifferencer.assertIsTrue(k >= 0 && k <= maxDiagonal);
                lastDiagonal[k] = row;
                if (row == rightSize && col == leftSize) {
                    return RangeDifferencer.createDifferencesRanges(script[k]);
                }
                if (row == rightSize) {
                    lower = k + 2;
                }
                if (col != leftSize) continue;
                upper = k - 2;
            }
            --lower;
            ++upper;
        }
        RangeDifferencer.assertIsTrue(false);
        return null;
    }

    public static RangeDifference[] findDifferences(I_RangeComparator ancestor, I_RangeComparator left, I_RangeComparator right) {
        if (ancestor == null) {
            return RangeDifferencer.findDifferences(left, right);
        }
        RangeDifference[] leftAncestorScript = null;
        RangeDifference[] rightAncestorScript = RangeDifferencer.findDifferences(ancestor, right);
        if (rightAncestorScript != null) {
            leftAncestorScript = RangeDifferencer.findDifferences(ancestor, left);
        }
        if (rightAncestorScript == null || leftAncestorScript == null) {
            return null;
        }
        DifferencesIterator myIter = new DifferencesIterator(rightAncestorScript);
        DifferencesIterator yourIter = new DifferencesIterator(leftAncestorScript);
        ArrayList<RangeDifference> diff3 = new ArrayList<RangeDifference>();
        diff3.add(new RangeDifference(5));
        int changeRangeStart = 0;
        int changeRangeEnd = 0;
        while (myIter.m_fDifference != null || yourIter.m_fDifference != null) {
            myIter.removeAll();
            yourIter.removeAll();
            DifferencesIterator startThread = myIter.m_fDifference == null ? yourIter : (yourIter.m_fDifference == null ? myIter : (myIter.m_fDifference.m_fLeftStart <= yourIter.m_fDifference.m_fLeftStart ? myIter : yourIter));
            changeRangeStart = startThread.m_fDifference.m_fLeftStart;
            changeRangeEnd = startThread.m_fDifference.leftEnd();
            startThread.next();
            DifferencesIterator other = startThread.other(myIter, yourIter);
            while (other.m_fDifference != null && other.m_fDifference.m_fLeftStart <= changeRangeEnd) {
                int newMax = other.m_fDifference.leftEnd();
                other.next();
                if (newMax < changeRangeEnd) continue;
                changeRangeEnd = newMax;
                other = other.other(myIter, yourIter);
            }
            diff3.add(RangeDifferencer.createRangeDifference3(myIter, yourIter, diff3, right, left, changeRangeStart, changeRangeEnd));
        }
        diff3.remove(0);
        return diff3.toArray(EMPTY_RESULT);
    }

    public static RangeDifference[] findRanges(I_RangeComparator left, I_RangeComparator right) {
        RangeDifference rd;
        RangeDifference[] in = RangeDifferencer.findDifferences(left, right);
        ArrayList<RangeDifference> out = new ArrayList<RangeDifference>();
        int mstart = 0;
        int ystart = 0;
        for (int i = 0; i < in.length; ++i) {
            RangeDifference es = in[i];
            rd = new RangeDifference(0, mstart, es.rightStart() - mstart, ystart, es.leftStart() - ystart);
            if (rd.maxLength() != 0) {
                out.add(rd);
            }
            out.add(es);
            mstart = es.rightEnd();
            ystart = es.leftEnd();
        }
        rd = new RangeDifference(0, mstart, right.getRangeCount() - mstart, ystart, left.getRangeCount() - ystart);
        if (rd.maxLength() > 0) {
            out.add(rd);
        }
        return out.toArray(EMPTY_RESULT);
    }

    public static RangeDifference[] findRanges(I_RangeComparator ancestor, I_RangeComparator left, I_RangeComparator right) {
        RangeDifference rd;
        if (ancestor == null) {
            return RangeDifferencer.findRanges(left, right);
        }
        RangeDifference[] in = RangeDifferencer.findDifferences(ancestor, left, right);
        ArrayList<RangeDifference> out = new ArrayList<RangeDifference>();
        int mstart = 0;
        int ystart = 0;
        int astart = 0;
        for (int i = 0; i < in.length; ++i) {
            RangeDifference es = in[i];
            rd = new RangeDifference(0, mstart, es.rightStart() - mstart, ystart, es.leftStart() - ystart, astart, es.ancestorStart() - astart);
            if (rd.maxLength() > 0) {
                out.add(rd);
            }
            out.add(es);
            mstart = es.rightEnd();
            ystart = es.leftEnd();
            astart = es.ancestorEnd();
        }
        rd = new RangeDifference(0, mstart, right.getRangeCount() - mstart, ystart, left.getRangeCount() - ystart, astart, ancestor.getRangeCount() - astart);
        if (rd.maxLength() > 0) {
            out.add(rd);
        }
        return out.toArray(EMPTY_RESULT);
    }

    private static RangeDifference[] createDifferencesRanges(LinkedRangeDifference start) {
        LinkedRangeDifference ep = RangeDifferencer.reverseDifferences(start);
        ArrayList<RangeDifference> result = new ArrayList<RangeDifference>();
        RangeDifference es = null;
        while (ep != null) {
            es = new RangeDifference(2);
            if (ep.isInsert()) {
                es.m_fRightStart = ep.m_fRightStart + 1;
                es.m_fLeftStart = ep.m_fLeftStart;
                LinkedRangeDifference b = ep;
                do {
                    if (ep != null) {
                        ep = ep.getNext();
                    }
                    ++es.m_fLeftLength;
                } while (ep != null && ep.isInsert() && ep.m_fRightStart == b.m_fRightStart);
            } else {
                boolean change;
                es.m_fRightStart = ep.m_fRightStart;
                es.m_fLeftStart = ep.m_fLeftStart;
                LinkedRangeDifference a = ep;
                do {
                    a = ep;
                    if (ep != null) {
                        ep = ep.getNext();
                    }
                    ++es.m_fRightLength;
                } while (ep != null && ep.isDelete() && ep.m_fRightStart == a.m_fRightStart + 1);
                boolean bl = change = ep != null && ep.isInsert() && ep.m_fRightStart == a.m_fRightStart;
                if (change) {
                    LinkedRangeDifference b = ep;
                    do {
                        if (ep != null) {
                            ep = ep.getNext();
                        }
                        ++es.m_fLeftLength;
                    } while (ep != null && ep.isInsert() && ep.m_fRightStart == b.m_fRightStart);
                } else {
                    es.m_fLeftLength = 0;
                }
                ++es.m_fLeftStart;
            }
            --es.m_fRightStart;
            --es.m_fLeftStart;
            result.add(es);
        }
        return result.toArray(EMPTY_RESULT);
    }

    private static RangeDifference createRangeDifference3(DifferencesIterator myIter, DifferencesIterator yourIter, List diff3, I_RangeComparator right, I_RangeComparator left, int changeRangeStart, int changeRangeEnd) {
        int leftEnd;
        int leftStart;
        RangeDifference l;
        RangeDifference f;
        int rightEnd;
        int rightStart;
        int kind = 5;
        RangeDifference last = (RangeDifference)diff3.get(diff3.size() - 1);
        RangeDifferencer.assertIsTrue(myIter.getCount() != 0 || yourIter.getCount() != 0);
        if (myIter.getCount() == 0) {
            rightStart = changeRangeStart - last.ancestorEnd() + last.rightEnd();
            rightEnd = changeRangeEnd - last.ancestorEnd() + last.rightEnd();
            kind = 3;
        } else {
            f = (RangeDifference)myIter.m_fRange.get(0);
            l = (RangeDifference)myIter.m_fRange.get(myIter.m_fRange.size() - 1);
            rightStart = changeRangeStart - f.m_fLeftStart + f.m_fRightStart;
            rightEnd = changeRangeEnd - l.leftEnd() + l.rightEnd();
        }
        if (yourIter.getCount() == 0) {
            leftStart = changeRangeStart - last.ancestorEnd() + last.leftEnd();
            leftEnd = changeRangeEnd - last.ancestorEnd() + last.leftEnd();
            kind = 2;
        } else {
            f = (RangeDifference)yourIter.m_fRange.get(0);
            l = (RangeDifference)yourIter.m_fRange.get(yourIter.m_fRange.size() - 1);
            leftStart = changeRangeStart - f.m_fLeftStart + f.m_fRightStart;
            leftEnd = changeRangeEnd - l.leftEnd() + l.rightEnd();
        }
        if (kind == 5) {
            kind = RangeDifferencer.rangeSpansEqual(right, rightStart, rightEnd - rightStart, left, leftStart, leftEnd - leftStart) ? 4 : 1;
        }
        return new RangeDifference(kind, rightStart, rightEnd - rightStart, leftStart, leftEnd - leftStart, changeRangeStart, changeRangeEnd - changeRangeStart);
    }

    private static boolean rangesEqual(I_RangeComparator a, int ai, I_RangeComparator b, int bi) {
        return a.rangesEqual(ai, b, bi);
    }

    private static boolean rangeSpansEqual(I_RangeComparator right, int rightStart, int rightLen, I_RangeComparator left, int leftStart, int leftLen) {
        if (rightLen == leftLen) {
            int i = 0;
            for (i = 0; i < rightLen && RangeDifferencer.rangesEqual(right, rightStart + i, left, leftStart + i); ++i) {
            }
            if (i == rightLen) {
                return true;
            }
        }
        return false;
    }

    private static LinkedRangeDifference reverseDifferences(LinkedRangeDifference start) {
        LinkedRangeDifference ep = null;
        for (LinkedRangeDifference ahead = start; ahead != null; ahead = ahead.getNext()) {
            LinkedRangeDifference behind = ep;
            ep = ahead;
            ep.setNext(behind);
        }
        return ep;
    }
}

