package com.alterioncorp.requestlogger;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.io.IOUtils;

public class CachedPayloadRequest extends HttpServletRequestWrapper {

	static class ServletInputStreamImpl extends ServletInputStream {
		
		private InputStream stream;
	
		ServletInputStreamImpl(InputStream stream) {
			super();
			this.stream = stream;
		}

		@Override
		public int read() throws IOException {
			return stream.read();
		}
	}
	
	private byte[] rawData;
	private ServletInputStreamImpl servletStream;
	
	public CachedPayloadRequest(HttpServletRequest request) {
		super(request);
	}
	
	@Override
	public ServletInputStream getInputStream() throws IOException {
		if (rawData == null) {
			rawData = IOUtils.toByteArray(this.getRequest().getInputStream());
			this.resetInputStream();
		}
		return servletStream;
	}
	
	@Override
	public BufferedReader getReader() throws IOException {
		Charset charset = this.getCharacterEncoding() == null ? Charset.defaultCharset() : Charset.forName(this.getCharacterEncoding());
		InputStream inputStream = this.getInputStream();
		return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, charset));
	}
	
	public void resetInputStream() {
		if (rawData != null) {
			servletStream = new ServletInputStreamImpl(new ByteArrayInputStream(rawData));
		}
	}
}
