package com.alterioncorp.requestlogger;

public interface Constants {
	
	String PROPERTY_NAME_ENABLED = "com.alterioncorp.requestlogger.enabled";
	String PROPERTY_NAME_QUEUE_MAX_SIZE = "com.alterioncorp.requestlogger.queue-max-size";
	String PROPERTY_NAME_PERSIST_PERIOD_IN_MILLIS = "com.alterioncorp.requestlogger.persist-period-in-millis";
	String PROPERTY_NAME_PARAMS_TO_SANITIZE = "com.alterioncorp.requestlogger.params-to-sanitize";
	String PROPERTY_NAME_PERSISTER_IMPL = "com.alterioncorp.requestlogger.persister";
	String PROPERTY_NAME_JDBC_DATASOURCE_JNDI = "com.alterioncorp.requestlogger.datasource.jndi";
	String PROPERTY_NAME_JDBC_TABLE_NAME = "com.alterioncorp.requestlogger.jdbc.table-name";
	
	String PROPERTY_DEFAULT_ENABLED = "true";
	String PROPERTY_DEFAULT_QUEUE_MAX_SIZE = "1048576";
	String PROPERTY_DEFAULT_PERSIST_PERIOD_IN_MILLIS  = "1000";
	String PROPERTY_DEFAULT_PARAMS_TO_SANITIZE = "password,j_password";
	String PROPERTY_DEFAULT_PERSISTER_IMPL = PersisterJdbcImpl.class.getName();
	String PROPERTY_DEFAULT_JDBC_DATASOURCE_JNDI  = "java:/comp/env/jdbc/request-logger";
	String PROPERTY_DEFAULT_JDBC_TABLE_NAME  = "RequestLog";
	
	String MBEAN_NAME_FILTER = "com.alterioncorp.requestlogger:type=RequestLoggerFilter";
	
	String REQUEST_PROPERTY_SESSION_ID = "sessionID";
	String REQUEST_PROPERTY_REQUEST_IP = "requestIP";
	String REQUEST_PROPERTY_SERVER_IP = "serverIP";
	String REQUEST_PROPERTY_START_TIME = "startTime";
	String REQUEST_PROPERTY_METHOD = "method";
	String REQUEST_PROPERTY_PATH = "path";
	String REQUEST_PROPERTY_REQUEST_CONTENT_TYPE = "requestContentType";
	String REQUEST_PROPERTY_REQUEST_BODY = "requestBody";
	String REQUEST_PROPERTY_DURATION = "duration";
	String REQUEST_PROPERTY_RESPONSE_STATUS = "responseStatus";
	String REQUEST_PROPERTY_ERROR = "error";
	String REQUEST_PROPERTY_SQL_DURATION = "sqlDuration";
}
