package com.alterioncorp.requestlogger;

import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PropertyRegistryImpl implements PropertyRegistry, Constants {

	private static final PropertyRegistryImpl instance;
	
	static {
		instance = new PropertyRegistryImpl();
		instance.registerProperty(REQUEST_PROPERTY_SESSION_ID, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_REQUEST_IP, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_SERVER_IP, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_START_TIME, Types.TIMESTAMP);
		instance.registerProperty(REQUEST_PROPERTY_METHOD, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_PATH, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_REQUEST_CONTENT_TYPE, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_REQUEST_BODY, Types.VARCHAR);
		instance.registerProperty(REQUEST_PROPERTY_DURATION, Types.BIGINT);
		instance.registerProperty(REQUEST_PROPERTY_RESPONSE_STATUS, Types.TINYINT);
		instance.registerProperty(REQUEST_PROPERTY_ERROR, Types.VARCHAR);
	}
	
	public static final PropertyRegistryImpl getInstance() {
		return instance;
	}
	
	private final ArrayList<String> properties;
	private final HashMap<String, Integer> typeRegistry;
	
	protected PropertyRegistryImpl() {
		super();
		this.properties = new ArrayList<String>();
		this.typeRegistry = new HashMap<String, Integer>();
	}

	@Override
	public final int getDataType(String property) {
		Integer type = typeRegistry.get(property);
		if (type == null) {
			throw new IllegalArgumentException("property not registered: " + property);
		}
		return type.intValue();
	}

	@Override
	public final void registerProperty(String property, int dataType) {
		if (typeRegistry.containsKey(property)) {
			throw new IllegalArgumentException("property already registered: " + property);			
		}
		properties.add(property);
		typeRegistry.put(property, dataType);		
	}

	@Override
	public final void unregisterProperty(String property) {
		if (! typeRegistry.containsKey(property)) {
			throw new IllegalArgumentException("property not registered: " + property);
		}
		properties.remove(property);
		typeRegistry.remove(property);
	}

	@Override
	public final List<String> getRegisteredProperties() {
		return Collections.unmodifiableList(properties);
	}
	
}
